/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryTemporaryOnConversionToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.to.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementString = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0]);
        String string = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.problem.descriptor", replacementString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    @NonNls
    static String calculateReplacementExpression(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (!(qualifier instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)qualifier;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] expressions = argumentList.getExpressions();
        if (expressions.length < 1) {
            return null;
        }
        PsiType type = newExpression.getType();
        if (type == null) {
            return null;
        }
        PsiExpression argument = expressions[0];
        String argumentText = argument.getText();
        String qualifierType = type.getPresentableText();
        return qualifierType + ".toString(" + argumentText + ')';
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0]);
        String name = InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.fix.name", replacement);
        return new UnnecessaryTemporaryObjectFix(name);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryTemporaryObjectVisitor();
    }

    private static class UnnecessaryTemporaryObjectVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> s_basicTypes = new HashSet<String>(8);

        private UnnecessaryTemporaryObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length < 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType != null && argumentType.equalsToText("java.lang.String")) {
                return;
            }
            PsiType type = qualifier.getType();
            if (type == null) {
                return;
            }
            String typeName = type.getCanonicalText();
            if (!s_basicTypes.contains(typeName)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        static {
            s_basicTypes.add("java.lang.Boolean");
            s_basicTypes.add("java.lang.Byte");
            s_basicTypes.add("java.lang.Character");
            s_basicTypes.add("java.lang.Double");
            s_basicTypes.add("java.lang.Float");
            s_basicTypes.add("java.lang.Integer");
            s_basicTypes.add("java.lang.Long");
            s_basicTypes.add("java.lang.Short");
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(String name) {
            this.m_name = name;
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/UnnecessaryTemporaryOnConversionToStringInspection$UnnecessaryTemporaryObjectFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)descriptor.getPsiElement();
            String newExpression = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression(expression);
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

