/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConstructorInspection
extends BaseInspection {
    public boolean ignoreSubstringArguments = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("RedundantStringConstructorCall" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConstructorInspection", "getID"));
        }
        return "RedundantStringConstructorCall";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConstructorInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.constructor.substring.parameter.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSubstringArguments");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean noArguments = (Boolean)infos[0];
        return new StringConstructorFix(noArguments);
    }

    private class StringConstructorVisitor
    extends BaseInspectionVisitor {
        private StringConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/StringConstructorInspection$StringConstructorVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 1) {
                return;
            }
            if (arguments.length == 1) {
                PsiExpression argument = arguments[0];
                PsiType parameterType = argument.getType();
                if (!TypeUtils.isJavaLangString(parameterType)) {
                    return;
                }
                if (StringConstructorInspection.this.ignoreSubstringArguments && this.hasSubstringArgument(argument)) {
                    return;
                }
            }
            this.registerError((PsiElement)expression, arguments.length == 0);
        }

        private boolean hasSubstringArgument(PsiExpression argument) {
            if (!(argument instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)argument;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement element = methodExpression.resolve();
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)element;
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className = aClass.getQualifiedName();
            String methodName = method.getName();
            return "java.lang.String".equals(className) && methodName.equals("substring");
        }
    }

    private static class StringConstructorFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private StringConstructorFix(boolean noArguments) {
            this.m_name = noArguments ? InspectionGadgetsBundle.message("string.constructor.replace.empty.quickfix", new Object[0]) : InspectionGadgetsBundle.message("string.constructor.replace.arg.quickfix", new Object[0]);
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConstructorInspection$StringConstructorFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringConstructorInspection$StringConstructorFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiNewExpression expression = (PsiNewExpression)descriptor.getPsiElement();
            PsiExpressionList argList = expression.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            String argText = args.length == 1 ? args[0].getText() : "\"\"";
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, argText);
        }
    }
}

