/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class InnerClassReferenceVisitor
extends JavaRecursiveElementVisitor {
    private final PsiClass innerClass;
    private boolean referencesStaticallyAccessible = true;

    public InnerClassReferenceVisitor(PsiClass innerClass) {
        this.innerClass = innerClass;
    }

    public boolean canInnerClassBeStatic() {
        return this.referencesStaticallyAccessible;
    }

    private boolean isClassStaticallyAccessible(PsiClass aClass) {
        if (PsiTreeUtil.isAncestor((PsiElement)this.innerClass, (PsiElement)aClass, (boolean)false)) {
            return true;
        }
        if (aClass.getContainingClass() != null) {
            return aClass.hasModifierProperty("static");
        }
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)this.innerClass, (PsiClass)aClass, (boolean)true)) {
            return true;
        }
        PsiClass classScope = aClass;
        PsiClass outerClass = ClassUtils.getContainingClass((PsiElement)this.innerClass);
        while (classScope != null) {
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)outerClass, (PsiClass)classScope, (boolean)true)) {
                return false;
            }
            PsiElement scope = classScope.getScope();
            if (scope instanceof PsiClass) {
                classScope = (PsiClass)scope;
                continue;
            }
            classScope = null;
        }
        return true;
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/InnerClassReferenceVisitor", "visitThisExpression"));
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitThisExpression(expression);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/InnerClassReferenceVisitor", "visitSuperExpression"));
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitSuperExpression(expression);
        if (this.hasContainingClassQualifier((PsiQualifiedExpression)expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private boolean hasContainingClassQualifier(PsiQualifiedExpression expression) {
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        if (qualifier == null) {
            return false;
        }
        PsiElement element = qualifier.resolve();
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return !aClass.equals(this.innerClass);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        PsiReferenceExpression referenceExpression;
        PsiElement resolvedExpression;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/InnerClassReferenceVisitor", "visitReferenceElement"));
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        PsiElement parent = reference.getParent();
        if (parent instanceof PsiThisExpression || parent instanceof PsiSuperExpression) {
            return;
        }
        super.visitReferenceElement(reference);
        PsiElement qualifier = reference.getQualifier();
        if (qualifier instanceof PsiSuperExpression) {
            return;
        }
        if (qualifier instanceof PsiReferenceExpression && !((resolvedExpression = (referenceExpression = (PsiReferenceExpression)qualifier).resolve()) instanceof PsiField) && !(resolvedExpression instanceof PsiMethod)) {
            return;
        }
        PsiElement element = reference.resolve();
        if (element instanceof PsiMethod || element instanceof PsiField) {
            PsiMember member = (PsiMember)element;
            if (member.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = member.getContainingClass();
            if (this.innerClass.equals(containingClass)) {
                return;
            }
            if (member.hasModifierProperty("private")) {
                this.referencesStaticallyAccessible = false;
                return;
            }
            this.referencesStaticallyAccessible &= this.isClassStaticallyAccessible(containingClass);
        } else if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
            PsiElement containingMethod = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiMethod.class);
            PsiElement referencedMethod = PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (containingMethod != null && referencedMethod != null && !containingMethod.equals(referencedMethod)) {
                this.referencesStaticallyAccessible = false;
            }
        } else if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            this.referencesStaticallyAccessible &= this.isClassStaticallyAccessible(aClass);
        }
    }
}

