/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallToSimpleGetterInClassInspection
extends BaseInspection {
    public boolean ignoreGetterCallsOnOtherObjects = false;
    public boolean onlyReportPrivateGetter = false;

    @NotNull
    public String getID() {
        if ("CallToSimpleGetterFromWithinClass" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspection", "getID"));
        }
        return "CallToSimpleGetterFromWithinClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.simple.getter.in.class.ignore.option", new Object[0]), "ignoreGetterCallsOnOtherObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.private.simple.getter.in.class.option", new Object[0]), "onlyReportPrivateGetter");
        return optionsPanel;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleGetterInClassVisitor();
    }

    private class CallToSimpleGetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleGetterInClassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspection$CallToSimpleGetterInClassVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(call);
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleGetterInClassInspection.this.ignoreGetterCallsOnOtherObjects) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)type;
                PsiClass qualifierClass = classType.resolve();
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if (!PropertyUtil.isSimpleGetter((PsiMethod)method)) {
                return;
            }
            if (CallToSimpleGetterInClassInspection.this.onlyReportPrivateGetter && !method.hasModifierProperty("private")) {
                return;
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)method, (boolean)true);
            PsiMethod overridingMethod = (PsiMethod)query.findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }
    }

    private static class InlineCallFix
    extends InspectionGadgetsFix {
        private InlineCallFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspection$InlineCallFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("call.to.simple.getter.in.class.inline.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CallToSimpleGetterInClassInspection$InlineCallFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodIdentifier = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodIdentifier.getParent();
            if (methodExpression == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)methodExpression.getParent();
            if (call == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            PsiReturnStatement returnStatement = (PsiReturnStatement)statements[0];
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)returnValue;
            PsiField field = (PsiField)referenceExpression.resolve();
            if (field == null) {
                return;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)call.getProject());
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiVariable variable = resolveHelper.resolveReferencedVariable(fieldName, (PsiElement)call);
                if (variable == null) {
                    return;
                }
                if (variable.equals(field)) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)call, fieldName);
                } else {
                    PsiReplacementUtil.replaceExpression((PsiExpression)call, "this." + fieldName);
                }
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)call, qualifier.getText() + '.' + fieldName);
            }
        }
    }
}

