/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PointlessArithmeticExpressionInspection
extends BaseInspection {
    private static final Set<IElementType> arithmeticTokens = new THashSet(9);
    public boolean m_ignoreExpressionsContainingConstants = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.arithmetic.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", this.calculateReplacementExpression((PsiExpression)infos[0]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @NonNls
    String calculateReplacementExpression(PsiExpression expression) {
        PsiBinaryExpression exp = (PsiBinaryExpression)expression;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        assert (rhs != null);
        IElementType tokenType = exp.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.PLUS)) {
            if (this.isZero(lhs)) {
                return rhs.getText();
            }
            return lhs.getText();
        }
        if (tokenType.equals(JavaTokenType.MINUS)) {
            if (this.isZero(rhs)) {
                return lhs.getText();
            }
            return "0";
        }
        if (tokenType.equals(JavaTokenType.ASTERISK)) {
            if (this.isOne(lhs)) {
                return rhs.getText();
            }
            if (this.isOne(rhs)) {
                return lhs.getText();
            }
            return "0";
        }
        if (tokenType.equals(JavaTokenType.DIV)) {
            if (ExpressionUtils.isOne(rhs)) {
                return lhs.getText();
            }
            return "1";
        }
        if (tokenType.equals(JavaTokenType.PERC)) {
            return "0";
        }
        if (tokenType.equals(JavaTokenType.LE) || tokenType.equals(JavaTokenType.GE)) {
            return "true";
        }
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.GT)) {
            return "false";
        }
        return "";
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessArithmeticFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    boolean isZero(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression);
    }

    boolean isOne(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isOne(expression);
    }

    private static boolean isMinDouble(PsiExpression expression) {
        Double value = (Double)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.DOUBLE);
        return value != null && value == Double.MIN_VALUE;
    }

    private static boolean isMaxDouble(PsiExpression expression) {
        Double value = (Double)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.DOUBLE);
        return value != null && value == Double.MAX_VALUE;
    }

    private static boolean isMinFloat(PsiExpression expression) {
        Float value = (Float)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.FLOAT);
        return value != null && value.floatValue() == Float.MIN_VALUE;
    }

    private static boolean isMaxFloat(PsiExpression expression) {
        Float value = (Float)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.FLOAT);
        return value != null && value.floatValue() == Float.MAX_VALUE;
    }

    private static boolean isMinInt(PsiExpression expression) {
        Integer value = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.INT);
        return value != null && value == Integer.MIN_VALUE;
    }

    private static boolean isMaxInt(PsiExpression expression) {
        Integer value = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.INT);
        return value != null && value == Integer.MAX_VALUE;
    }

    private static boolean isMinLong(PsiExpression expression) {
        Long value = (Long)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.LONG);
        return value != null && value == Long.MIN_VALUE;
    }

    private static boolean isMaxLong(PsiExpression expression) {
        Long value = (Long)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.LONG);
        return value != null && value == Long.MAX_VALUE;
    }

    static {
        arithmeticTokens.add(JavaTokenType.PLUS);
        arithmeticTokens.add(JavaTokenType.MINUS);
        arithmeticTokens.add(JavaTokenType.ASTERISK);
        arithmeticTokens.add(JavaTokenType.DIV);
        arithmeticTokens.add(JavaTokenType.PERC);
        arithmeticTokens.add(JavaTokenType.GT);
        arithmeticTokens.add(JavaTokenType.LT);
        arithmeticTokens.add(JavaTokenType.LE);
        arithmeticTokens.add(JavaTokenType.GE);
    }

    private class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private PointlessArithmeticVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (PsiType.DOUBLE.equals((Object)expressionType) || PsiType.FLOAT.equals((Object)expressionType)) {
                return;
            }
            if (!arithmeticTokens.contains(expression.getOperationTokenType())) {
                return;
            }
            if (ExpressionUtils.hasStringType((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            IElementType tokenType = expression.getOperationTokenType();
            boolean isPointless = tokenType.equals(JavaTokenType.PLUS) ? this.additionExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.MINUS) ? this.subtractionExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.ASTERISK) ? this.multiplyExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.DIV) ? this.divideExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.PERC) ? this.modExpressionIsPointless(lhs, rhs) : (tokenType.equals(JavaTokenType.LE) || tokenType.equals(JavaTokenType.GE) || tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.LT) ? this.comparisonExpressionIsPointless(lhs, rhs, tokenType) : false)))));
            if (!isPointless) {
                return;
            }
            if (!(PsiType.BOOLEAN.equals((Object)expressionType) || expressionType != null && expressionType.equals(rhs.getType()) && expressionType.equals(lhs.getType()))) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean subtractionExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            if (PsiType.INT.equals((Object)lhs.getType()) && EquivalenceChecker.expressionsAreEquivalent(lhs, rhs)) {
                return true;
            }
            return PointlessArithmeticExpressionInspection.this.isZero(rhs);
        }

        private boolean additionExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessArithmeticExpressionInspection.this.isZero(lhs) || PointlessArithmeticExpressionInspection.this.isZero(rhs);
        }

        private boolean multiplyExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            return PointlessArithmeticExpressionInspection.this.isZero(lhs) || PointlessArithmeticExpressionInspection.this.isZero(rhs) || PointlessArithmeticExpressionInspection.this.isOne(lhs) || PointlessArithmeticExpressionInspection.this.isOne(rhs);
        }

        private boolean divideExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            if (PsiType.INT.equals((Object)lhs.getType()) && EquivalenceChecker.expressionsAreEquivalent(lhs, rhs)) {
                return true;
            }
            return PointlessArithmeticExpressionInspection.this.isOne(rhs);
        }

        private boolean modExpressionIsPointless(PsiExpression lhs, PsiExpression rhs) {
            if (PsiType.INT.equals((Object)lhs.getType()) && EquivalenceChecker.expressionsAreEquivalent(lhs, rhs)) {
                return true;
            }
            return PsiType.INT.equals((Object)rhs.getType()) && PointlessArithmeticExpressionInspection.this.isOne(rhs);
        }

        private boolean comparisonExpressionIsPointless(PsiExpression lhs, PsiExpression rhs, IElementType comparison) {
            if (PsiType.INT.equals((Object)lhs.getType()) && PsiType.INT.equals((Object)rhs.getType())) {
                return this.intComparisonIsPointless(lhs, rhs, comparison);
            }
            if (PsiType.LONG.equals((Object)lhs.getType()) && PsiType.LONG.equals((Object)rhs.getType())) {
                return this.longComparisonIsPointless(lhs, rhs, comparison);
            }
            return false;
        }

        private boolean intComparisonIsPointless(PsiExpression lhs, PsiExpression rhs, IElementType comparison) {
            if (PointlessArithmeticExpressionInspection.isMaxInt(lhs) || PointlessArithmeticExpressionInspection.isMinInt(rhs)) {
                return JavaTokenType.GE.equals(comparison) || JavaTokenType.LT.equals(comparison);
            }
            if (PointlessArithmeticExpressionInspection.isMinInt(lhs) || PointlessArithmeticExpressionInspection.isMaxInt(rhs)) {
                return JavaTokenType.LE.equals(comparison) || JavaTokenType.GT.equals(comparison);
            }
            return false;
        }

        private boolean longComparisonIsPointless(PsiExpression lhs, PsiExpression rhs, IElementType comparison) {
            if (PointlessArithmeticExpressionInspection.isMaxLong(lhs) || PointlessArithmeticExpressionInspection.isMinLong(rhs)) {
                return JavaTokenType.GE.equals(comparison) || JavaTokenType.LT.equals(comparison);
            }
            if (PointlessArithmeticExpressionInspection.isMinLong(lhs) || PointlessArithmeticExpressionInspection.isMaxLong(rhs)) {
                return JavaTokenType.LE.equals(comparison) || JavaTokenType.GT.equals(comparison);
            }
            return false;
        }
    }

    private class PointlessArithmeticFix
    extends InspectionGadgetsFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            String newExpression = PointlessArithmeticExpressionInspection.this.calculateReplacementExpression(expression);
            PsiReplacementUtil.replaceExpression(expression, newExpression);
        }
    }
}

