/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OverlyComplexArithmeticExpressionInspectionBase
extends BaseInspection {
    protected static final Set<IElementType> arithmeticTokens = new HashSet<IElementType>(5);
    private static final int TERM_LIMIT = 6;
    public int m_limit = 6;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyComplexArithmeticExpressionVisitor();
    }

    private class OverlyComplexArithmeticExpressionVisitor
    extends BaseInspectionVisitor {
        private OverlyComplexArithmeticExpressionVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspectionBase$OverlyComplexArithmeticExpressionVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspectionBase$OverlyComplexArithmeticExpressionVisitor", "visitPrefixExpression"));
            }
            super.visitPrefixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            if (this.isParentArithmetic(expression)) {
                return;
            }
            if (!this.isArithmetic(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= OverlyComplexArithmeticExpressionInspectionBase.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private int countTerms(PsiExpression expression) {
            if (!this.isArithmetic(expression)) {
                return 1;
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiExpression operand = prefixExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentArithmetic(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            return parent instanceof PsiExpression && this.isArithmetic((PsiExpression)parent);
        }

        private boolean isArithmetic(PsiExpression expression) {
            if (expression instanceof PsiBinaryExpression) {
                PsiType type = expression.getType();
                if (TypeUtils.isJavaLangString(type)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                return arithmeticTokens.contains(binaryExpression.getOperationTokenType());
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                return arithmeticTokens.contains(prefixExpression.getOperationTokenType());
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.isArithmetic(contents);
            }
            return false;
        }
    }
}

