/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntegerDivisionInFloatingPointContextInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_integralTypes = new HashSet<String>(10);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("integer.division.in.floating.point.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("integer.division.in.floating.point.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerDivisionInFloatingPointContextVisitor();
    }

    static {
        s_integralTypes.add("int");
        s_integralTypes.add("long");
        s_integralTypes.add("short");
        s_integralTypes.add("byte");
        s_integralTypes.add("char");
        s_integralTypes.add("java.lang.Integer");
        s_integralTypes.add("java.lang.Long");
        s_integralTypes.add("java.lang.Short");
        s_integralTypes.add("java.lang.Byte");
        s_integralTypes.add("java.lang.Character");
    }

    private static class IntegerDivisionInFloatingPointContextVisitor
    extends BaseInspectionVisitor {
        private IntegerDivisionInFloatingPointContextVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection$IntegerDivisionInFloatingPointContextVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.DIV)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (!IntegerDivisionInFloatingPointContextVisitor.isIntegral(lhsType)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (!IntegerDivisionInFloatingPointContextVisitor.isIntegral(rhsType)) {
                return;
            }
            PsiExpression context = IntegerDivisionInFloatingPointContextVisitor.getContainingExpression((PsiExpression)expression);
            if (context == null) {
                return;
            }
            PsiType contextType = ExpectedTypeUtils.findExpectedType(context, true);
            if (contextType == null) {
                return;
            }
            if (!contextType.equals(PsiType.FLOAT) && !contextType.equals(PsiType.DOUBLE)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isIntegral(PsiType type) {
            if (type == null) {
                return false;
            }
            String text = type.getCanonicalText();
            return text != null && s_integralTypes.contains(text);
        }

        private static PsiExpression getContainingExpression(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiBinaryExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                return IntegerDivisionInFloatingPointContextVisitor.getContainingExpression((PsiExpression)parent);
            }
            return expression;
        }
    }
}

