/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.NestingDepthVisitor;
import org.jetbrains.annotations.NotNull;

public class NestingDepthInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        if ("OverlyNestedMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NestingDepthInspection", "getID"));
        }
        return "OverlyNestedMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nesting.depth.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NestingDepthInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("nesting.depth.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer nestingDepth = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("nesting.depth.problem.descriptor", nestingDepth);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/NestingDepthInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestingDepthMethodVisitor();
    }

    private class NestingDepthMethodVisitor
    extends BaseInspectionVisitor {
        private NestingDepthMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/NestingDepthInspection$NestingDepthMethodVisitor", "visitMethod"));
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NestingDepthVisitor visitor = new NestingDepthVisitor();
            method.accept((PsiElementVisitor)visitor);
            int count = visitor.getMaximumDepth();
            if (count <= NestingDepthInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, count);
        }
    }
}

