/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ZeroLengthArrayInitializationInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ZeroLengthArrayAllocation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/ZeroLengthArrayInitializationInspectionBase", "getID"));
        }
        return "ZeroLengthArrayAllocation";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.allocation.zero.length.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/ZeroLengthArrayInitializationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.allocation.zero.length.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/ZeroLengthArrayInitializationInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ZeroLengthArrayInitializationVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static class ZeroLengthArrayInitializationVisitor
    extends BaseInspectionVisitor {
        private ZeroLengthArrayInitializationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/memory/ZeroLengthArrayInitializationInspectionBase$ZeroLengthArrayInitializationVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            if (!ExpressionUtils.isZeroLengthArrayConstruction((PsiExpression)expression)) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiExpression[] initializers = expression.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (expression.getParent() instanceof PsiNewExpression) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

