/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticCollectionInspection
extends BaseInspection {
    public boolean m_ignoreWeakCollections = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.collection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/StaticCollectionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.collection.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/memory/StaticCollectionInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("static.collection.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreWeakCollections");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticCollectionVisitor();
    }

    private class StaticCollectionVisitor
    extends BaseInspectionVisitor {
        private StaticCollectionVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/memory/StaticCollectionInspection$StaticCollectionVisitor", "visitField"));
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiType type = field.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return;
            }
            if (!StaticCollectionInspection.this.m_ignoreWeakCollections || CollectionUtils.isWeakCollectionClass(type)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

