/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SuppressionAnnotationInspectionBase
extends BaseInspection {
    public List<String> myAllowedSuppressions = new ArrayList<String>();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuppressionAnnotationVisitor();
    }

    private class SuppressionAnnotationVisitor
    extends BaseInspectionVisitor {
        private SuppressionAnnotationVisitor() {
        }

        public void visitComment(PsiComment comment) {
            String strippedComment;
            super.visitComment(comment);
            String commentText = comment.getText();
            IElementType tokenType = comment.getTokenType();
            if (!tokenType.equals(JavaTokenType.END_OF_LINE_COMMENT) && !tokenType.equals(JavaTokenType.C_STYLE_COMMENT)) {
                return;
            }
            if (commentText.length() > 2 && (strippedComment = commentText.substring(2).trim()).startsWith("noinspection")) {
                Iterable ids;
                String suppressedIds = JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)comment);
                Iterable iterable = ids = suppressedIds != null ? StringUtil.tokenize((String)suppressedIds, (String)"[, ]") : null;
                if (ids != null) {
                    for (String id : ids) {
                        if (SuppressionAnnotationInspectionBase.this.myAllowedSuppressions.contains(id)) continue;
                        this.registerError((PsiElement)comment, comment);
                        break;
                    }
                }
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            Collection<String> ids;
            PsiElement annotationParent;
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null) {
                return;
            }
            String text = reference.getText();
            if (("SuppressWarnings".equals(text) || "java.lang.SuppressWarnings".equals(text)) && (annotationParent = annotation.getParent()) instanceof PsiModifierList && !SuppressionAnnotationInspectionBase.this.myAllowedSuppressions.containsAll(ids = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierList)annotationParent))) {
                this.registerError((PsiElement)annotation, annotation);
            }
        }
    }
}

