/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.maturity.SuppressionAnnotationInspectionBase;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SuppressionAnnotationInspection
extends SuppressionAnnotationInspectionBase {
    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore suppressions", this.myAllowedSuppressions);
        return form.getContentPanel();
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        if (infos.length == 1) {
            if (infos[0] instanceof PsiAnnotation) {
                PsiAnnotation annotation = (PsiAnnotation)infos[0];
                PsiElement parent = annotation.getParent();
                Collection<String> ids = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierList)parent);
                if (!ids.isEmpty()) {
                    InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new DelegatingFix(new RemoveAnnotationQuickFix(annotation, null)), new AllowSuppressionsFix()};
                    if (inspectionGadgetsFixArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection", "buildFixes"));
                    }
                    return inspectionGadgetsFixArray;
                }
            } else if (infos[0] instanceof PsiComment) {
                InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RemoveSuppressCommentFix(), new AllowSuppressionsFix()};
                if (inspectionGadgetsFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection", "buildFixes"));
                }
                return inspectionGadgetsFixArray;
            }
        }
        if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection", "buildFixes"));
        }
        return InspectionGadgetsFix.EMPTY_ARRAY;
    }

    private class AllowSuppressionsFix
    extends InspectionGadgetsFix {
        private AllowSuppressionsFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            Iterable ids;
            PsiElement psiElement = descriptor.getPsiElement();
            String suppressedIds = JavaSuppressionUtil.getSuppressedInspectionIdsIn(psiElement);
            Iterable iterable = ids = suppressedIds != null ? StringUtil.tokenize((String)suppressedIds, (String)"[, ]") : null;
            if (ids != null) {
                for (String id : ids) {
                    if (SuppressionAnnotationInspection.this.myAllowedSuppressions.contains(id)) continue;
                    SuppressionAnnotationInspection.this.myAllowedSuppressions.add(id);
                }
                this.saveProfile(project);
            }
        }

        private void saveProfile(Project project) {
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
            InspectionProfileManager.getInstance().fireProfileChanged((Profile)inspectionProfile);
        }

        @NotNull
        public String getName() {
            if ("Allow these suppressions" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection$AllowSuppressionsFix", "getName"));
            }
            return "Allow these suppressions";
        }

        @NotNull
        public String getFamilyName() {
            if ("Allow suppressions" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection$AllowSuppressionsFix", "getFamilyName"));
            }
            return "Allow suppressions";
        }
    }

    private static class RemoveSuppressCommentFix
    extends InspectionGadgetsFix {
        private RemoveSuppressCommentFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement != null) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(psiElement)) {
                    return;
                }
                psiElement.delete();
            }
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection$RemoveSuppressCommentFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove //noinspection" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection$RemoveSuppressCommentFix", "getFamilyName"));
            }
            return "Remove //noinspection";
        }
    }
}

