/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit3StyleTestMethodInJUnit4ClassInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit3StyleTestMethodInJUnit4ClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit3StyleTestMethodInJUnit4ClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DelegatingFix(new AnnotateMethodFix("org.junit.Test", new String[0]){

            @Override
            public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
                return 1;
            }
        });
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor();
    }

    public static boolean containsReferenceToClass(PsiElement element, String fullyQualifiedName) {
        ClassReferenceVisitor visitor = new ClassReferenceVisitor(fullyQualifiedName);
        element.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    private static class ClassReferenceVisitor
    extends JavaRecursiveElementVisitor {
        private final String fullyQualifiedName;
        private boolean referenceFound = false;

        private ClassReferenceVisitor(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (this.referenceFound) {
                return;
            }
            if (!(reference.getParent() instanceof PsiAnnotation)) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            String classQualifiedName = aClass.getQualifiedName();
            if (classQualifiedName == null || !classQualifiedName.equals(this.fullyQualifiedName)) {
                return;
            }
            this.referenceFound = true;
        }

        public boolean isReferenceFound() {
            return this.referenceFound;
        }
    }

    private static class JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor
    extends BaseInspectionVisitor {
        private JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            String name = method.getName();
            if (!name.startsWith("test")) {
                return;
            }
            if (method.hasModifierProperty("abstract") || !method.hasModifierProperty("public")) {
                return;
            }
            if (TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null || !returnType.equals(PsiType.VOID)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (TestUtils.isJUnitTestClass(containingClass)) {
                return;
            }
            if (!JUnit3StyleTestMethodInJUnit4ClassInspection.containsReferenceToClass((PsiElement)containingClass, "org.junit.Test")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

