/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.performance.InnerClassReferenceVisitor;
import org.jetbrains.annotations.NotNull;

public class AnonymousInnerClassMayBeStaticInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/AnonymousInnerClassMayBeStaticInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("anonymous.inner.may.be.named.static.inner.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/AnonymousInnerClassMayBeStaticInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousInnerClassMayBeStaticVisitor();
    }

    private static class AnonymousInnerClassMayBeStaticVisitor
    extends BaseInspectionVisitor {
        private AnonymousInnerClassMayBeStaticVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/j2me/AnonymousInnerClassMayBeStaticInspectionBase$AnonymousInnerClassMayBeStaticVisitor", "visitClass"));
            }
            if (!(aClass instanceof PsiAnonymousClass)) {
                return;
            }
            if (aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            PsiMember containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMember.class);
            if (containingMember == null || containingMember.hasModifierProperty("static")) {
                return;
            }
            PsiAnonymousClass anAnonymousClass = (PsiAnonymousClass)aClass;
            InnerClassReferenceVisitor visitor = new InnerClassReferenceVisitor((PsiClass)anAnonymousClass);
            anAnonymousClass.accept((PsiElementVisitor)visitor);
            if (!visitor.canInnerClassBeStatic()) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

