/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ImplicitDefaultCharsetUsageInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos[0] instanceof PsiNewExpression) {
            String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitDefaultCharsetUsageVisitor();
    }

    private static class ImplicitDefaultCharsetUsageVisitor
    extends BaseInspectionVisitor {
        private ImplicitDefaultCharsetUsageVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"getBytes".equals(name)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 1) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qName = aClass.getQualifiedName();
            if (!"java.lang.String".equals(qName)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (aClass == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            int count = parameterList.getParametersCount();
            if (count == 0) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            String qName = aClass.getQualifiedName();
            if ("java.lang.String".equals(qName)) {
                if (!parameters[0].getType().equalsToText("byte[]") || ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters[count - 1])) {
                    return;
                }
            } else if ("java.io.InputStreamReader".equals(qName) || "java.io.OutputStreamWriter".equals(qName) || "java.io.PrintStream".equals(qName)) {
                if (ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters[count - 1])) {
                    return;
                }
            } else if ("java.io.PrintWriter".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters[count - 1]) || parameters[0].getType().equalsToText("java.io.Writer")) {
                    return;
                }
            } else if ("java.util.Formatter".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters[1])) {
                    return;
                }
                PsiType firstType = parameters[0].getType();
                if (!(firstType.equalsToText("java.lang.String") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.io.OutputStream"))) {
                    return;
                }
            } else if ("java.util.Scanner".equals(qName)) {
                if (count > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType((PsiVariable)parameters[1])) {
                    return;
                }
                PsiType firstType = parameters[0].getType();
                if (!(firstType.equalsToText("java.io.InputStream") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.nio.file.Path") || firstType.equalsToText("java.nio.channels.ReadableByteChannel"))) {
                    return;
                }
            } else if (!"java.io.FileReader".equals(qName) && !"java.io.FileWriter".equals(qName)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private static boolean hasCharsetType(PsiVariable variable) {
            PsiType lastType = variable.getType();
            return lastType.equalsToText("java.lang.String") || lastType.equalsToText("java.nio.charset.Charset");
        }
    }
}

