/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NonProtectedConstructorInAbstractClassInspection
extends BaseInspection {
    public boolean m_ignoreNonPublicClasses = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("ConstructorNotProtectedInAbstractClass" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection", "getID"));
        }
        return "ConstructorNotProtectedInAbstractClass";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreNonPublicClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonProtectedConstructorInAbstractClassVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("protected");
    }

    private class NonProtectedConstructorInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private NonProtectedConstructorInAbstractClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/inheritance/NonProtectedConstructorInAbstractClassInspection$NonProtectedConstructorInAbstractClassVisitor", "visitMethod"));
            }
            if (!method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("protected") || method.hasModifierProperty("private") || method.hasModifierProperty("packageLocal")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (NonProtectedConstructorInAbstractClassInspection.this.m_ignoreNonPublicClasses && !containingClass.hasModifierProperty("public")) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

