/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ImportsAreUsedVisitor
extends JavaRecursiveElementVisitor {
    private final PsiJavaFile myFile;
    private final List<PsiImportStatementBase> importStatements;
    private final List<PsiImportStatementBase> usedImportStatements = new ArrayList<PsiImportStatementBase>();

    ImportsAreUsedVisitor(PsiJavaFile file) {
        this.myFile = file;
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            this.importStatements = Collections.EMPTY_LIST;
        } else {
            PsiImportStatementBase[] importStatements = importList.getAllImportStatements();
            this.importStatements = new ArrayList<PsiImportStatementBase>(Arrays.asList(importStatements));
            Collections.reverse(this.importStatements);
        }
    }

    public void visitElement(PsiElement element) {
        if (this.importStatements.isEmpty()) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/imports/ImportsAreUsedVisitor", "visitReferenceElement"));
        }
        this.followReferenceToImport(reference);
        super.visitReferenceElement(reference);
    }

    private void followReferenceToImport(PsiJavaCodeReferenceElement reference) {
        if (reference.getQualifier() != null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(true);
        PsiElement element = resolveResult.getElement();
        if (element == null) {
            return;
        }
        if (this.findImport(element, this.usedImportStatements) != null) {
            return;
        }
        PsiImportStatementBase foundImport = this.findImport(element, this.importStatements);
        if (foundImport != null) {
            this.importStatements.remove(foundImport);
            this.usedImportStatements.add(foundImport);
        }
    }

    private PsiImportStatementBase findImport(PsiElement element, List<PsiImportStatementBase> importStatements) {
        String referenceName;
        PsiClass referenceClass;
        String packageName;
        String qualifiedName;
        if (element instanceof PsiClass) {
            PsiClass referencedClass = (PsiClass)element;
            qualifiedName = referencedClass.getQualifiedName();
            packageName = qualifiedName != null ? StringUtil.getPackageName((String)qualifiedName) : null;
        } else {
            qualifiedName = null;
            packageName = null;
        }
        if (element instanceof PsiMember) {
            PsiMember member = (PsiMember)element;
            if (member instanceof PsiClass && !member.hasModifierProperty("static")) {
                referenceClass = null;
                referenceName = null;
            } else {
                referenceClass = member.getContainingClass();
                referenceName = member.getName();
            }
        } else {
            referenceClass = null;
            referenceName = null;
        }
        boolean hasOnDemandImportConflict = qualifiedName != null && ImportUtils.hasOnDemandImportConflict(qualifiedName, this.myFile);
        for (PsiImportStatementBase importStatementBase : importStatements) {
            String importReferenceName;
            PsiClass targetClass;
            PsiImportStaticStatement importStaticStatement;
            PsiImportStatement importStatement;
            String importName;
            if (importStatementBase instanceof PsiImportStatement && qualifiedName != null && packageName != null && (importName = (importStatement = (PsiImportStatement)importStatementBase).getQualifiedName()) != null) {
                if (importStatement.isOnDemand()) {
                    if (hasOnDemandImportConflict) continue;
                    if (importName.equals(packageName)) {
                        return importStatement;
                    }
                } else if (importName.equals(qualifiedName)) {
                    return importStatement;
                }
            }
            if (!(importStatementBase instanceof PsiImportStaticStatement) || referenceClass == null || referenceName == null || !((importStaticStatement = (PsiImportStaticStatement)importStatementBase).isOnDemand() ? InheritanceUtil.isInheritorOrSelf((PsiClass)(targetClass = importStaticStatement.resolveTargetClass()), (PsiClass)referenceClass, (boolean)true) : (importReferenceName = importStaticStatement.getReferenceName()) != null && importReferenceName.equals(referenceName))) continue;
            return importStaticStatement;
        }
        return null;
    }

    public PsiImportStatementBase[] getUnusedImportStatements() {
        if (this.importStatements.isEmpty()) {
            return PsiImportStatementBase.EMPTY_ARRAY;
        }
        return this.importStatements.toArray(new PsiImportStatementBase[this.importStatements.size()]);
    }
}

