/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class IntroduceConstantFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceConstantFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("introduce.constant.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/IntroduceConstantFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(final @NotNull Project project, ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/fixes/IntroduceConstantFix", "doFix"));
        }
        final PsiElement constant = descriptor.getPsiElement();
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!constant.isValid()) {
                    return;
                }
                JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
                RefactoringActionHandler introduceHandler = factory.createIntroduceConstantHandler();
                DataManager dataManager = DataManager.getInstance();
                DataContext dataContext = dataManager.getDataContext();
                introduceHandler.invoke(project, new PsiElement[]{constant}, dataContext);
            }
        }, project.getDisposed());
    }
}

