/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class InlineCallFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/InlineCallFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("inline.call.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/InlineCallFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(final Project project, ProblemDescriptor descriptor) {
        PsiElement nameElement = descriptor.getPsiElement();
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)nameElement.getParent();
        assert (methodExpression != null);
        final PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        final RefactoringActionHandler inlineHandler = factory.createInlineHandler();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                inlineHandler.invoke(project, new PsiElement[]{methodCallExpression}, null);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed());
        }
    }
}

