/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FinalizeInspection
extends BaseInspection {
    public boolean ignoreTrivialFinalizers = true;

    @NotNull
    public String getID() {
        if ("FinalizeDeclaration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeInspection", "getID"));
        }
        return "FinalizeDeclaration";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("finalize.declaration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/finalization/FinalizeInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.trivial.finalizers.option", new Object[0]), (InspectionProfileEntry)this, "ignoreTrivialFinalizers");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalizeDeclaredVisitor();
    }

    private class FinalizeDeclaredVisitor
    extends BaseInspectionVisitor {
        private FinalizeDeclaredVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/finalization/FinalizeInspection$FinalizeDeclaredVisitor", "visitMethod"));
            }
            String methodName = method.getName();
            if (!"finalize".equals(methodName)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            if (FinalizeInspection.this.ignoreTrivialFinalizers && this.isTrivial(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isTrivial(PsiMethod method) {
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return true;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return true;
            }
            Project project = method.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiConstantEvaluationHelper evaluationHelper = psiFacade.getConstantEvaluationHelper();
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiIfStatement)) {
                    return false;
                }
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition = ifStatement.getCondition();
                Object result = evaluationHelper.computeConstantExpression((PsiElement)condition);
                if (result != null && result.equals(Boolean.FALSE)) continue;
                return false;
            }
            return true;
        }
    }
}

