/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.errorhandling.CatchParameterUsedVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnusedCatchParameterInspectionBase
extends BaseInspection {
    public boolean m_ignoreCatchBlocksWithComments = false;
    public boolean m_ignoreTestCases = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unused.catch.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UnusedCatchParameterInspectionBase", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unused.catch.parameter.ignore.catch.option", new Object[0]), "m_ignoreCatchBlocksWithComments");
        return optionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean namedIgnoreButUsed = (Boolean)infos[0];
        if (namedIgnoreButUsed) {
            String string = InspectionGadgetsBundle.message("used.catch.parameter.named.ignore.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UnusedCatchParameterInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unused.catch.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/UnusedCatchParameterInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedCatchParameterVisitor();
    }

    private class UnusedCatchParameterVisitor
    extends BaseInspectionVisitor {
        private UnusedCatchParameterVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/errorhandling/UnusedCatchParameterInspectionBase$UnusedCatchParameterVisitor", "visitTryStatement"));
            }
            super.visitTryStatement(statement);
            if (UnusedCatchParameterInspectionBase.this.m_ignoreTestCases && TestUtils.isInTestCode((PsiElement)statement)) {
                return;
            }
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                this.checkCatchSection(catchSection);
            }
        }

        private void checkCatchSection(PsiCatchSection section) {
            PsiParameter parameter = section.getParameter();
            if (parameter == null) {
                return;
            }
            String parameterName = parameter.getName();
            PsiCodeBlock block = section.getCatchBlock();
            if (block == null) {
                return;
            }
            if (UnusedCatchParameterInspectionBase.this.m_ignoreCatchBlocksWithComments) {
                PsiElement[] children;
                for (PsiElement child : children = block.getChildren()) {
                    if (!(child instanceof PsiComment)) continue;
                    return;
                }
            }
            CatchParameterUsedVisitor visitor = new CatchParameterUsedVisitor(parameter);
            block.accept((PsiElementVisitor)visitor);
            boolean namedIgnore = PsiUtil.isIgnoredName((String)parameterName);
            if (visitor.isUsed()) {
                if (namedIgnore) {
                    this.registerVariableError((PsiVariable)parameter, Boolean.TRUE, parameter);
                }
                return;
            }
            if (namedIgnore) {
                return;
            }
            this.registerVariableError((PsiVariable)parameter, Boolean.FALSE, parameter);
        }
    }
}

