/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TooBroadCatchInspectionBase
extends BaseInspection {
    public boolean onlyWarnOnRootExceptions = false;
    public boolean ignoreInTestCode = false;
    public boolean ignoreThrown = false;

    @NotNull
    public String getID() {
        if ("OverlyBroadCatchBlock" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspectionBase", "getID"));
        }
        return "OverlyBroadCatchBlock";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.catch.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        List typesMasked = (List)infos[0];
        String typesMaskedString = ((PsiClass)typesMasked.get(0)).getName();
        if (typesMasked.size() == 1) {
            String string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor", typesMaskedString);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspectionBase", "buildErrorString"));
            }
            return string;
        }
        int lastTypeIndex = typesMasked.size() - 1;
        for (int i = 1; i < lastTypeIndex; ++i) {
            typesMaskedString = typesMaskedString + ", ";
            typesMaskedString = typesMaskedString + ((PsiClass)typesMasked.get(i)).getName();
        }
        String lastTypeString = ((PsiClass)typesMasked.get(lastTypeIndex)).getName();
        String string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor1", typesMaskedString, lastTypeString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadCatchVisitor();
    }

    private class TooBroadCatchVisitor
    extends BaseInspectionVisitor {
        private TooBroadCatchVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/errorhandling/TooBroadCatchInspectionBase$TooBroadCatchVisitor", "visitTryStatement"));
            }
            super.visitTryStatement(statement);
            PsiCodeBlock tryBlock = statement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Set<PsiClassType> thrownTypes = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
            HashSet<PsiType> caughtTypes = new HashSet<PsiType>(thrownTypes.size());
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                PsiParameter parameter = catchSection.getParameter();
                if (parameter == null) continue;
                PsiType caughtType = parameter.getType();
                if (caughtType instanceof PsiDisjunctionType) {
                    PsiDisjunctionType disjunctionType = (PsiDisjunctionType)caughtType;
                    List types = disjunctionType.getDisjunctions();
                    for (PsiType type : types) {
                        this.check(thrownTypes, caughtTypes, parameter, type);
                    }
                    continue;
                }
                if (thrownTypes.isEmpty()) {
                    PsiTypeElement typeElement;
                    if (!"java.lang.Exception".equals(caughtType.getCanonicalText()) || (typeElement = parameter.getTypeElement()) == null) continue;
                    PsiClass runtimeExceptionClass = ClassUtils.findClass("java.lang.RuntimeException", (PsiElement)parameter);
                    this.registerError((PsiElement)typeElement, Collections.singletonList(runtimeExceptionClass), typeElement);
                    continue;
                }
                this.check(thrownTypes, caughtTypes, parameter, caughtType);
            }
        }

        private void check(Set<PsiClassType> thrownTypes, Set<PsiType> caughtTypes, PsiParameter parameter, PsiType caughtType) {
            List<PsiClass> maskedExceptions = this.findMaskedExceptions(thrownTypes, caughtTypes, caughtType);
            if (maskedExceptions.isEmpty()) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, maskedExceptions, typeElement);
        }

        private List<PsiClass> findMaskedExceptions(Set<PsiClassType> thrownTypes, Set<PsiType> caughtTypes, PsiType caughtType) {
            if (thrownTypes.contains(caughtType)) {
                if (TooBroadCatchInspectionBase.this.ignoreThrown) {
                    return Collections.emptyList();
                }
                caughtTypes.add(caughtType);
                thrownTypes.remove(caughtType);
            }
            if (TooBroadCatchInspectionBase.this.onlyWarnOnRootExceptions && !ExceptionUtils.isGenericExceptionClass(caughtType)) {
                return Collections.emptyList();
            }
            ArrayList<PsiClass> maskedTypes = new ArrayList<PsiClass>();
            for (PsiClassType typeThrown : thrownTypes) {
                if (caughtTypes.contains(typeThrown) || !caughtType.isAssignableFrom((PsiType)typeThrown)) continue;
                caughtTypes.add((PsiType)typeThrown);
                PsiClass aClass = typeThrown.resolve();
                if (aClass == null) continue;
                maskedTypes.add(aClass);
            }
            return maskedTypes;
        }
    }
}

