/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ReturnFromFinallyBlockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ReturnInsideFinallyBlock" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection", "getID"));
        }
        return "ReturnInsideFinallyBlock";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.from.finally.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("return.from.finally.block.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnFromFinallyBlockVisitor();
    }

    private static class ReturnFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ReturnFromFinallyBlockVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection$ReturnFromFinallyBlockVisitor", "visitReturnStatement"));
            }
            super.visitReturnStatement(statement);
            if (!ControlFlowUtils.isInFinallyBlock((PsiElement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

