/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnOfDateFieldInspection
extends BaseInspection {
    public boolean ignorePrivateMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.date.calendar.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("return.date.calendar.field.problem.descriptor", type);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("return.of.null.ignore.private.option", new Object[0]), (InspectionProfileEntry)this, "ignorePrivateMethods");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReturnOfDateFieldFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfDateFieldVisitor();
    }

    private class ReturnOfDateFieldVisitor
    extends BaseInspectionVisitor {
        private ReturnOfDateFieldVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection$ReturnOfDateFieldVisitor", "visitReturnStatement"));
            }
            super.visitReturnStatement(statement);
            PsiExpression returnValue = statement.getReturnValue();
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (method == null || ReturnOfDateFieldInspection.this.ignorePrivateMethods && method.hasModifierProperty("private")) {
                return;
            }
            PsiReferenceExpression fieldReference = (PsiReferenceExpression)returnValue;
            PsiElement element = fieldReference.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(returnValue, "java.util.Date", "java.util.Calendar");
            if (type == null) {
                return;
            }
            this.registerError((PsiElement)returnValue, type);
        }
    }

    private static class ReturnOfDateFieldFix
    extends InspectionGadgetsFix {
        private final String myType;

        public ReturnOfDateFieldFix(String type) {
            this.myType = type;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("return.date.calendar.field.quickfix", this.myType);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection$ReturnOfDateFieldFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Return clone" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection$ReturnOfDateFieldFix", "getFamilyName"));
            }
            return "Return clone";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String type = TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Date", "java.util.Calendar");
            if (type == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, '(' + type + ')' + referenceExpression.getText() + ".clone()");
        }
    }
}

