/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PublicFieldInspectionBase
extends BaseInspection {
    public boolean ignoreEnums = false;
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/PublicFieldInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/PublicFieldInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldVisitor();
    }

    private class PublicFieldVisitor
    extends BaseInspectionVisitor {
        private PublicFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/encapsulation/PublicFieldInspectionBase$PublicFieldVisitor", "visitField"));
            }
            if (!field.hasModifierProperty("public")) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (Collection)((Object)PublicFieldInspectionBase.this.ignorableAnnotations))) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                PsiClassType classType;
                PsiClass aClass;
                if (field.hasModifierProperty("static")) {
                    return;
                }
                PsiType type = field.getType();
                if (ClassUtils.isImmutable(type)) {
                    return;
                }
                if (PublicFieldInspectionBase.this.ignoreEnums && type instanceof PsiClassType && (aClass = (classType = (PsiClassType)type).resolve()) != null && aClass.isEnum()) {
                    return;
                }
            }
            this.registerFieldError(field, field);
        }
    }
}

