/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointlessNullCheckInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("pointless.nullcheck.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessNullCheckVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        return new PointlessNullCheckFix(expression.getText());
    }

    private static boolean referencesEqual(PsiReferenceExpression reference1, PsiReferenceExpression reference2) {
        if (reference1 == null || reference2 == null) {
            return false;
        }
        PsiElement target1 = reference1.resolve();
        if (target1 == null) {
            return false;
        }
        PsiElement target2 = reference2.resolve();
        return target1.equals(target2);
    }

    private static class PointlessNullCheckVisitor
    extends BaseInspectionVisitor {
        private PointlessNullCheckVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            PsiReferenceExpression referenceExpression1;
            IElementType tokenType;
            PsiExpression possibleInstanceofExpression;
            PsiBinaryExpression binaryExpression;
            super.visitBinaryExpression(expression);
            IElementType operationTokenType = expression.getOperationTokenType();
            PsiExpression lhs = ParenthesesUtils.stripParentheses(expression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
            if (operationTokenType.equals(JavaTokenType.ANDAND)) {
                if (lhs instanceof PsiBinaryExpression) {
                    binaryExpression = (PsiBinaryExpression)lhs;
                    possibleInstanceofExpression = rhs;
                } else if (rhs instanceof PsiBinaryExpression) {
                    binaryExpression = (PsiBinaryExpression)rhs;
                    possibleInstanceofExpression = lhs;
                } else {
                    return;
                }
                tokenType = binaryExpression.getOperationTokenType();
                if (!tokenType.equals(JavaTokenType.NE)) {
                    return;
                }
            } else if (operationTokenType.equals(JavaTokenType.OROR)) {
                IElementType prefixTokenType;
                PsiPrefixExpression prefixExpression;
                if (lhs instanceof PsiBinaryExpression && rhs instanceof PsiPrefixExpression) {
                    prefixExpression = (PsiPrefixExpression)rhs;
                    prefixTokenType = prefixExpression.getOperationTokenType();
                    if (!JavaTokenType.EXCL.equals(prefixTokenType)) {
                        return;
                    }
                    binaryExpression = (PsiBinaryExpression)lhs;
                    possibleInstanceofExpression = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                } else if (rhs instanceof PsiBinaryExpression && lhs instanceof PsiPrefixExpression) {
                    prefixExpression = (PsiPrefixExpression)lhs;
                    prefixTokenType = prefixExpression.getOperationTokenType();
                    if (!JavaTokenType.EXCL.equals(prefixTokenType)) {
                        return;
                    }
                    binaryExpression = (PsiBinaryExpression)rhs;
                    possibleInstanceofExpression = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                } else {
                    return;
                }
                tokenType = binaryExpression.getOperationTokenType();
                if (!tokenType.equals(JavaTokenType.EQEQ)) {
                    return;
                }
            } else {
                return;
            }
            if ((referenceExpression1 = PointlessNullCheckVisitor.getReferenceFromNullCheck(binaryExpression)) == null) {
                return;
            }
            PsiReferenceExpression referenceExpression2 = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(possibleInstanceofExpression);
            if (!PointlessNullCheckInspection.referencesEqual(referenceExpression1, referenceExpression2)) {
                return;
            }
            this.registerError((PsiElement)binaryExpression, binaryExpression);
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromNullCheck(PsiBinaryExpression expression) {
            PsiExpression lhs = ParenthesesUtils.stripParentheses(expression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
            if (lhs instanceof PsiReferenceExpression) {
                if (!(rhs instanceof PsiLiteralExpression) || !PsiType.NULL.equals((Object)rhs.getType())) {
                    return null;
                }
                return (PsiReferenceExpression)lhs;
            }
            if (rhs instanceof PsiReferenceExpression) {
                if (!(lhs instanceof PsiLiteralExpression) || !PsiType.NULL.equals((Object)lhs.getType())) {
                    return null;
                }
                return (PsiReferenceExpression)rhs;
            }
            return null;
        }

        @Nullable
        private static PsiReferenceExpression getReferenceFromInstanceofExpression(PsiExpression expression) {
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(parenthesizedExpression.getExpression());
            }
            if (expression instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
                PsiExpression operand = ParenthesesUtils.stripParentheses(instanceOfExpression.getOperand());
                if (!(operand instanceof PsiReferenceExpression)) {
                    return null;
                }
                return (PsiReferenceExpression)operand;
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (JavaTokenType.OROR != tokenType) {
                    return null;
                }
                PsiExpression[] operands = polyadicExpression.getOperands();
                PsiReferenceExpression referenceExpression = PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(operands[0]);
                if (referenceExpression == null) {
                    return null;
                }
                int operandsLength = operands.length;
                for (int i = 1; i < operandsLength; ++i) {
                    if (PointlessNullCheckInspection.referencesEqual(referenceExpression, PointlessNullCheckVisitor.getReferenceFromInstanceofExpression(operands[i]))) continue;
                    return null;
                }
                return referenceExpression;
            }
            return null;
        }
    }

    private static class PointlessNullCheckFix
    extends InspectionGadgetsFix {
        private final String myExpressionText;

        public PointlessNullCheckFix(String expressionText) {
            this.myExpressionText = expressionText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("pointless.nullcheck.simplify.quickfix", this.myExpressionText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/PointlessNullCheckInspection$PointlessNullCheckFix", "getFamilyName"));
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiBinaryExpression.class);
            if (binaryExpression == null) {
                return;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)rhs, (PsiElement)element, (boolean)false)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, lhs.getText());
            } else if (PsiTreeUtil.isAncestor((PsiElement)lhs, (PsiElement)element, (boolean)false)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, rhs.getText());
            }
        }
    }
}

