/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MethodCountInspection
extends BaseInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 20;
    public int m_limit = 20;
    public boolean ignoreGettersAndSetters = false;
    public boolean ignoreOverridingMethods = false;

    @NotNull
    public String getID() {
        if ("ClassWithTooManyMethods" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classmetrics/MethodCountInspection", "getID"));
        }
        return "ClassWithTooManyMethods";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.many.methods.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classmetrics/MethodCountInspection", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]));
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.right = 10;
        constraints.anchor = 17;
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        panel.add((Component)valueField, constraints);
        CheckBox gettersSettersCheckBox = new CheckBox(InspectionGadgetsBundle.message("method.count.ignore.getters.setters.option", new Object[0]), (InspectionProfileEntry)this, "ignoreGettersAndSetters");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        panel.add((Component)gettersSettersCheckBox, constraints);
        CheckBox overridingMethodCheckBox = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), (InspectionProfileEntry)this, "ignoreOverridingMethods");
        constraints.weighty = 1.0;
        constraints.gridy = 2;
        constraints.anchor = 18;
        panel.add((Component)overridingMethodCheckBox, constraints);
        return panel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("too.many.methods.problem.descriptor", count);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classmetrics/MethodCountInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCountVisitor();
    }

    private class MethodCountVisitor
    extends BaseInspectionVisitor {
        private MethodCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/classmetrics/MethodCountInspection$MethodCountVisitor", "visitClass"));
            }
            int methodCount = this.calculateTotalMethodCount(aClass);
            if (methodCount <= MethodCountInspection.this.m_limit) {
                return;
            }
            this.registerClassError(aClass, methodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            int totalCount = 0;
            for (PsiMethod method : methods) {
                if (method.isConstructor() || MethodCountInspection.this.ignoreGettersAndSetters && (PropertyUtil.isSimpleGetter((PsiMethod)method) || PropertyUtil.isSimpleSetter((PsiMethod)method)) || MethodCountInspection.this.ignoreOverridingMethods && MethodUtils.hasSuper(method)) continue;
                ++totalCount;
            }
            return totalCount;
        }
    }
}

