/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityClassWithoutPrivateConstructorInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean ignoreClassesWithOnlyMain = false;

    @Nullable
    static PsiMethod getNullArgConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            PsiParameterList params = constructor.getParameterList();
            if (params.getParametersCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("utility.class.without.private.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UtilityClassWithoutPrivateConstructorVisitor();
    }

    private class UtilityClassWithoutPrivateConstructorVisitor
    extends BaseInspectionVisitor {
        private UtilityClassWithoutPrivateConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/classlayout/UtilityClassWithoutPrivateConstructorInspectionBase$UtilityClassWithoutPrivateConstructorVisitor", "visitClass"));
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (UtilityClassWithoutPrivateConstructorInspectionBase.this.ignoreClassesWithOnlyMain && this.hasOnlyMain(aClass)) {
                return;
            }
            if (this.hasPrivateConstructor(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)UtilityClassWithoutPrivateConstructorInspectionBase.this.ignorableAnnotations))) {
                return;
            }
            if (aClass.hasModifierProperty("private") && aClass.getConstructors().length == 0) {
                return;
            }
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)aClass.getProject());
            Query query = ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true, (boolean)true);
            PsiClass subclass = (PsiClass)query.findFirst();
            if (subclass != null) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private boolean hasOnlyMain(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length == 0) {
                return false;
            }
            for (PsiMethod method : methods) {
                if (method.isConstructor()) continue;
                if (!method.hasModifierProperty("static")) {
                    return false;
                }
                if (method.hasModifierProperty("private")) continue;
                if (!method.hasModifierProperty("public")) {
                    return false;
                }
                String name = method.getName();
                if (!name.equals("main")) {
                    return false;
                }
                PsiType returnType = method.getReturnType();
                if (!PsiType.VOID.equals((Object)returnType)) {
                    return false;
                }
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 1) {
                    return false;
                }
                PsiParameter[] parameters = parameterList.getParameters();
                PsiParameter parameter = parameters[0];
                PsiType type = parameter.getType();
                if (type.equalsToText("java.lang.String[]")) continue;
                return false;
            }
            return true;
        }

        boolean hasPrivateConstructor(PsiClass aClass) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                if (!constructor.hasModifierProperty("private")) continue;
                return true;
            }
            return false;
        }
    }
}

