/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import org.jetbrains.annotations.NotNull;

public class FinalMethodInFinalClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("final.method.in.final.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalMethodInFinalClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FinalMethodInFinalClassVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("final.method.in.final.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalMethodInFinalClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static class FinalMethodInFinalClassVisitor
    extends BaseInspectionVisitor {
        private FinalMethodInFinalClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/classlayout/FinalMethodInFinalClassInspection$FinalMethodInFinalClassVisitor", "visitMethod"));
            }
            if (!method.hasModifierProperty("final")) {
                return;
            }
            if (!method.hasModifierProperty("static") && AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{"java.lang.SafeVarargs"}) != null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || containingClass.isEnum()) {
                return;
            }
            if (!containingClass.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)method, "final");
        }
    }
}

