/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class ObjectEqualsNullInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.equals.null.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ObjectEqualsNullInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("object.equals.null.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ObjectEqualsNullInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualsNullVisitor();
    }

    private static class ObjectEqualsNullVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualsNullVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/ObjectEqualsNullInspection$ObjectEqualsNullVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(call);
            if (!MethodCallUtils.isEqualsCall(call)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length == 0 || !ExpressionUtils.isNullLiteral(args[0])) {
                return;
            }
            this.registerError((PsiElement)args[0], new Object[0]);
        }
    }
}

