/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEqualityInspection
extends BaseInspection {
    public boolean m_ignoreEnums = true;
    public boolean m_ignoreClassObjects = false;
    public boolean m_ignorePrivateConstructors = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.comparison.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ObjectEqualityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("object.comparison.problem.description", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ObjectEqualityInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.enumerated.ignore.option", new Object[0]), "m_ignoreEnums");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.klass.ignore.option", new Object[0]), "m_ignoreClassObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.equality.ignore.between.objects.of.a.type.with.only.private.constructors.option", new Object[0]), "m_ignorePrivateConstructors");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualityVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualityToEqualsFix();
    }

    private class ObjectEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/ObjectEqualityInspection$ObjectEqualityVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (!this.isObjectType(rhs)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!this.isObjectType(lhs)) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignoreEnums && (this.isEnumType(rhs) || this.isEnumType(lhs))) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignoreClassObjects && (this.isClass(rhs) || this.isClass(lhs))) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignorePrivateConstructors && (this.typeHasPrivateConstructor(lhs) || this.typeHasPrivateConstructor(rhs))) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (method != null && MethodUtils.isEquals(method)) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            this.registerError((PsiElement)sign, new Object[0]);
        }

        private boolean typeHasPrivateConstructor(@Nullable PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass != null && aClass.isInterface()) {
                return this.implementersHaveOnlyPrivateConstructors(aClass);
            }
            return this.hasOnlyPrivateConstructors(aClass);
        }

        private boolean implementersHaveOnlyPrivateConstructors(final PsiClass aClass) {
            final GlobalSearchScope scope = GlobalSearchScope.allScope((Project)aClass.getProject());
            final PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(6);
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.runProcess(new Runnable(){

                @Override
                public void run() {
                    ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
                }
            }, null);
            if (processor.isOverflow()) {
                return false;
            }
            Collection implementers = processor.getCollection();
            for (PsiClass implementer : implementers) {
                if (implementer.isInterface() || implementer.hasModifierProperty("abstract") || this.hasOnlyPrivateConstructors(implementer)) continue;
                return false;
            }
            return true;
        }

        private boolean hasOnlyPrivateConstructors(PsiClass aClass) {
            if (aClass == null) {
                return false;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return false;
            }
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                return false;
            }
            return true;
        }

        private boolean isClass(@Nullable PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PsiClassObjectAccessExpression) {
                return true;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClassType rawType = classType.rawType();
            return rawType.equalsToText("java.lang.Class");
        }

        private boolean isEnumType(@Nullable PsiExpression expression) {
            return expression != null && TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.Enum");
        }

        private boolean isObjectType(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            return type != null && !(type instanceof PsiArrayType) && !(type instanceof PsiPrimitiveType) && !TypeUtils.isJavaLangString(type) && !TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.Number");
        }
    }
}

