/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IgnoreResultOfCallInspectionBase
extends BaseInspection {
    final List<String> methodNamePatterns = new ArrayList<String>();
    final List<String> classNames = new ArrayList<String>();
    public boolean m_reportAllNonLibraryCalls = false;
    @NonNls
    public String callCheckString = "java.io.File,.*,java.io.InputStream,read|skip|available|markSupported,java.io.Writer,read|skip|ready|markSupported,java.lang.Boolean,.*,java.lang.Byte,.*,java.lang.Character,.*,java.lang.Double,.*,java.lang.Float,.*,java.lang.Integer,.*,java.lang.Long,.*,java.lang.Math,.*,java.lang.Object,equals|hashCode|toString,java.lang.Short,.*,java.lang.StrictMath,.*,java.lang.String,.*,java.math.BigInteger,.*,java.math.BigDecimal,.*,java.net.InetAddress,.*,java.net.URI,.*,java.util.UUID,.*,java.util.regex.Matcher,pattern|toMatchResult|start|end|group|groupCount|matches|find|lookingAt|quoteReplacement|replaceAll|replaceFirst|regionStart|regionEnd|hasTransparantBounds|hasAnchoringBounds|hitEnd|requireEnd,java.util.regex.Pattern,.*";
    Map<String, Pattern> patternCache = null;

    public IgnoreResultOfCallInspectionBase() {
        IgnoreResultOfCallInspectionBase.parseString(this.callCheckString, this.classNames, this.methodNamePatterns);
    }

    @NotNull
    public String getID() {
        if ("ResultOfMethodCallIgnored" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getID"));
        }
        return "ResultOfMethodCallIgnored";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String className = containingClass.getName();
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        IgnoreResultOfCallInspectionBase.parseString(this.callCheckString, this.classNames, this.methodNamePatterns);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "writeSettings"));
        }
        this.callCheckString = IgnoreResultOfCallInspectionBase.formatString(this.classNames, this.methodNamePatterns);
        super.writeSettings(element);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase$IgnoreResultOfCallVisitor", "visitExpressionStatement"));
            }
            super.visitExpressionStatement(statement);
            PsiExpression expression = statement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiMethod method = call.resolveMethod();
            if (method == null || method.isConstructor()) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (PsiType.VOID.equals((Object)returnType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
                return;
            }
            if (IgnoreResultOfCallInspectionBase.this.m_reportAllNonLibraryCalls && !LibraryUtil.classIsInLibrary(aClass)) {
                this.registerMethodCallError(call, aClass);
                return;
            }
            PsiAnnotation contractAnnotation = ControlFlowAnalyzer.findContractAnnotation(method);
            if (contractAnnotation != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)contractAnnotation, (String)"pure"))) {
                this.registerMethodCallError(call, aClass);
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return;
            }
            for (int i = 0; i < IgnoreResultOfCallInspectionBase.this.methodNamePatterns.size(); ++i) {
                String className;
                String methodNamePattern = IgnoreResultOfCallInspectionBase.this.methodNamePatterns.get(i);
                if (!this.methodNamesMatch(methodName, methodNamePattern) || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)(className = IgnoreResultOfCallInspectionBase.this.classNames.get(i)))) continue;
                this.registerMethodCallError(call, aClass);
                return;
            }
        }

        private boolean methodNamesMatch(String methodName, String methodNamePattern) {
            Pattern pattern;
            if (IgnoreResultOfCallInspectionBase.this.patternCache != null) {
                pattern = IgnoreResultOfCallInspectionBase.this.patternCache.get(methodNamePattern);
            } else {
                IgnoreResultOfCallInspectionBase.this.patternCache = new HashMap<String, Pattern>(IgnoreResultOfCallInspectionBase.this.methodNamePatterns.size());
                pattern = null;
            }
            if (pattern == null) {
                try {
                    pattern = Pattern.compile(methodNamePattern);
                    IgnoreResultOfCallInspectionBase.this.patternCache.put(methodNamePattern, pattern);
                }
                catch (PatternSyntaxException ignore) {
                    return false;
                }
                catch (NullPointerException ignore) {
                    return false;
                }
            }
            if (pattern == null) {
                return false;
            }
            Matcher matcher = pattern.matcher(methodName);
            return matcher.matches();
        }
    }
}

