/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectionUpdateCalledVisitor
extends JavaRecursiveElementVisitor {
    @NonNls
    private final Set<String> updateNames;
    private boolean updated = false;
    private final PsiVariable variable;

    CollectionUpdateCalledVisitor(@Nullable PsiVariable variable, Set<String> updateNames) {
        this.variable = variable;
        this.updateNames = updateNames;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/CollectionUpdateCalledVisitor", "visitElement"));
        }
        if (!this.updated) {
            super.visitElement(element);
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        super.visitMethodReferenceExpression(expression);
        if (this.updated) {
            return;
        }
        String methodName = expression.getReferenceName();
        if (this.checkMethodName(methodName)) {
            return;
        }
        this.checkQualifier(expression.getQualifierExpression());
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/CollectionUpdateCalledVisitor", "visitMethodCallExpression"));
        }
        super.visitMethodCallExpression(call);
        if (this.updated) {
            return;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (this.checkMethodName(methodName)) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        this.checkQualifier(qualifier);
    }

    private boolean checkMethodName(String methodName) {
        if (methodName == null) {
            return true;
        }
        if (!this.updateNames.contains(methodName)) {
            boolean found = false;
            for (String updateName : this.updateNames) {
                if (!methodName.startsWith(updateName)) continue;
                found = true;
                break;
            }
            if (!found) {
                return true;
            }
        }
        return false;
    }

    private void checkQualifier(PsiExpression expression) {
        if (this.updated) {
            return;
        }
        if (this.variable != null && expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.variable)) {
                this.updated = true;
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            this.checkQualifier(parenthesizedExpression.getExpression());
        } else if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            this.checkQualifier(thenExpression);
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            this.checkQualifier(elseExpression);
        } else if (this.variable == null && (expression == null || expression instanceof PsiThisExpression || expression instanceof PsiSuperExpression)) {
            this.updated = true;
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }
}

