/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class CollectionAddedToSelfInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collection.added.to.self.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/CollectionAddedToSelfInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("collection.added.to.self.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/CollectionAddedToSelfInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionAddedToSelfVisitor();
    }

    private static class CollectionAddedToSelfVisitor
    extends BaseInspectionVisitor {
        private CollectionAddedToSelfVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiExpression[] args;
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/CollectionAddedToSelfInspection$CollectionAddedToSelfVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("put".equals(methodName) || "set".equals(methodName) || "add".equals(methodName))) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiVariable)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            boolean hasMatchingArg = false;
            for (PsiExpression arg : args = argumentList.getExpressions()) {
                if (!EquivalenceChecker.expressionsAreEquivalent(qualifier, arg)) continue;
                hasMatchingArg = true;
            }
            if (!hasMatchingArg) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)qualifierType;
            PsiClass qualifierClass = classType.resolve();
            if (qualifierClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiClass)qualifierClass, (String)"java.util.Map")) {
                return;
            }
            this.registerError((PsiElement)qualifier, new Object[0]);
        }
    }
}

