/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PointlessBitwiseExpressionInspection
extends BaseInspection {
    public boolean m_ignoreExpressionsContainingConstants = false;
    static final Set<IElementType> bitwiseTokens = new HashSet<IElementType>(6);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[0];
        String replacementExpression = this.calculateReplacementExpression(polyadicExpression);
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", replacementExpression);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.bitwise.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression) {
        block8: {
            PsiExpression[] operands;
            IElementType tokenType;
            block10: {
                block9: {
                    block7: {
                        tokenType = expression.getOperationTokenType();
                        operands = expression.getOperands();
                        if (!tokenType.equals(JavaTokenType.AND)) break block7;
                        for (PsiExpression operand : operands) {
                            if (this.isZero(operand)) {
                                return operand.getText();
                            }
                            if (!this.isAllOnes(operand)) continue;
                            return PointlessBitwiseExpressionInspection.getText(expression, operand);
                        }
                        break block8;
                    }
                    if (!tokenType.equals(JavaTokenType.OR)) break block9;
                    for (PsiExpression operand : operands) {
                        if (this.isZero(operand)) {
                            return PointlessBitwiseExpressionInspection.getText(expression, operand);
                        }
                        if (!this.isAllOnes(operand)) continue;
                        return operand.getText();
                    }
                    break block8;
                }
                if (!tokenType.equals(JavaTokenType.XOR)) break block10;
                for (PsiExpression operand : operands) {
                    if (this.isAllOnes(operand)) {
                        return '~' + PointlessBitwiseExpressionInspection.getText(expression, operand);
                    }
                    if (!this.isZero(operand)) continue;
                    return PointlessBitwiseExpressionInspection.getText(expression, operand);
                }
                break block8;
            }
            if (!tokenType.equals(JavaTokenType.LTLT) && !tokenType.equals(JavaTokenType.GTGT) && !tokenType.equals(JavaTokenType.GTGTGT)) break block8;
            for (PsiExpression operand : operands) {
                if (!this.isZero(operand)) continue;
                return PointlessBitwiseExpressionInspection.getText(expression, operand);
            }
        }
        return "";
    }

    private static String getText(PsiPolyadicExpression expression, PsiExpression exclude) {
        PsiExpression[] operands = expression.getOperands();
        boolean addToken = false;
        StringBuilder text = new StringBuilder();
        for (PsiExpression operand : operands) {
            if (operand == exclude) continue;
            if (addToken) {
                PsiJavaToken token = expression.getTokenBeforeOperand(operand);
                text.append(' ');
                if (token != null) {
                    text.append(token.getText());
                    text.append(' ');
                }
            } else {
                addToken = true;
            }
            text.append(operand.getText());
        }
        return text.toString();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessBitwiseFix();
    }

    private boolean isZero(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression);
    }

    private boolean isAllOnes(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiType expressionType = expression.getType();
        Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Integer && (Integer)value == -1) {
            return true;
        }
        if (value instanceof Long && (Long)value == -1L) {
            return true;
        }
        if (value instanceof Short && (Short)value == -1) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\uffff') {
            return true;
        }
        return value instanceof Byte && (Byte)value == -1;
    }

    static {
        bitwiseTokens.add(JavaTokenType.AND);
        bitwiseTokens.add(JavaTokenType.OR);
        bitwiseTokens.add(JavaTokenType.XOR);
        bitwiseTokens.add(JavaTokenType.LTLT);
        bitwiseTokens.add(JavaTokenType.GTGT);
        bitwiseTokens.add(JavaTokenType.GTGTGT);
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private PointlessBitwiseVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            PsiExpression[] operands;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseVisitor", "visitPolyadicExpression"));
            }
            super.visitPolyadicExpression(expression);
            IElementType sign = expression.getOperationTokenType();
            if (!bitwiseTokens.contains(sign)) {
                return;
            }
            for (PsiExpression operand : operands = expression.getOperands()) {
                if (operand == null) {
                    return;
                }
                PsiType type = operand.getType();
                if (type != null && !type.equals(PsiType.BOOLEAN) && !type.equalsToText("java.lang.Boolean")) continue;
                return;
            }
            boolean isPointless = sign.equals(JavaTokenType.AND) || sign.equals(JavaTokenType.OR) || sign.equals(JavaTokenType.XOR) ? this.booleanExpressionIsPointless(operands) : (sign.equals(JavaTokenType.LTLT) || sign.equals(JavaTokenType.GTGT) || sign.equals(JavaTokenType.GTGTGT) ? this.shiftExpressionIsPointless(operands) : false);
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean booleanExpressionIsPointless(PsiExpression[] operands) {
            for (PsiExpression operand : operands) {
                if (!PointlessBitwiseExpressionInspection.this.isZero(operand) && !PointlessBitwiseExpressionInspection.this.isAllOnes(operand)) continue;
                return true;
            }
            return false;
        }

        private boolean shiftExpressionIsPointless(PsiExpression[] operands) {
            for (int i = 1; i < operands.length; ++i) {
                PsiExpression operand = operands[i];
                if (!PointlessBitwiseExpressionInspection.this.isZero(operand)) continue;
                return true;
            }
            return false;
        }
    }

    private class PointlessBitwiseFix
    extends InspectionGadgetsFix {
        private PointlessBitwiseFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiPolyadicExpression expression = (PsiPolyadicExpression)descriptor.getPsiElement();
            String newExpression = PointlessBitwiseExpressionInspection.this.calculateReplacementExpression(expression);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

