/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ExtractParameterAsLocalVariableFix;
import com.siyeh.ig.psiutils.WellFormednessUtils;
import org.jetbrains.annotations.NotNull;

public class AssignmentToCatchBlockParameterInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.catch.block.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToCatchBlockParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.catch.block.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToCatchBlockParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtractParameterAsLocalVariableFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToCatchBlockParameterVisitor();
    }

    private static class AssignmentToCatchBlockParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToCatchBlockParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/assignment/AssignmentToCatchBlockParameterInspection$AssignmentToCatchBlockParameterVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            if (!WellFormednessUtils.isWellFormed(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
            PsiElement variable = reference.resolve();
            if (!(variable instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)variable;
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection)) {
                return;
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }
    }
}

