/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InstanceofChainInspection
extends BaseInspection {
    public boolean ignoreInstanceofOnLibraryClasses = false;

    @NotNull
    public String getID() {
        if ("ChainOfInstanceofChecks" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofChainInspection", "getID"));
        }
        return "ChainOfInstanceofChecks";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofChainInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chain.of.instanceof.checks.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofChainInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.instanceof.on.library.classes", new Object[0]), (InspectionProfileEntry)this, "ignoreInstanceofOnLibraryClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofChainVisitor();
    }

    private class InstanceofChainVisitor
    extends BaseInspectionVisitor {
        private InstanceofChainVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            PsiIfStatement previousIfStatement;
            PsiIfStatement parentStatement;
            PsiStatement elseBranch;
            if (ifStatement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/abstraction/InstanceofChainInspection$InstanceofChainVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(ifStatement);
            PsiElement parent = ifStatement.getParent();
            if (parent instanceof PsiIfStatement && ifStatement.equals(elseBranch = (parentStatement = (PsiIfStatement)parent).getElseBranch())) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)ifStatement, PsiStatement.class);
            if (previousStatement instanceof PsiIfStatement && this.isInstanceofCheck((previousIfStatement = (PsiIfStatement)previousStatement).getCondition())) {
                return;
            }
            int numChecks = 0;
            PsiIfStatement branch = ifStatement;
            while (true) {
                PsiStatement nextStatement;
                PsiExpression condition;
                if (!this.isInstanceofCheck(condition = branch.getCondition())) {
                    if (numChecks > 1) break;
                    return;
                }
                ++numChecks;
                PsiStatement elseBranch2 = branch.getElseBranch();
                if (elseBranch2 instanceof PsiIfStatement) {
                    branch = (PsiIfStatement)elseBranch2;
                    continue;
                }
                if (elseBranch2 != null || !((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)branch, PsiStatement.class)) instanceof PsiIfStatement)) break;
                branch = (PsiIfStatement)nextStatement;
            }
            if (numChecks < 2) {
                return;
            }
            this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
        }

        private boolean isInstanceofCheck(PsiExpression condition) {
            while (true) {
                if (condition == null) {
                    return false;
                }
                if (condition instanceof PsiInstanceOfExpression) {
                    PsiInstanceOfExpression instanceOfExpression;
                    return !InstanceofChainInspection.this.ignoreInstanceofOnLibraryClasses || !this.isInstanceofOnLibraryClass(instanceOfExpression = (PsiInstanceOfExpression)condition);
                }
                if (condition instanceof PsiPolyadicExpression) {
                    PsiExpression[] operands;
                    PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
                    for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                        if (this.isInstanceofCheck(operand)) continue;
                        return false;
                    }
                    return true;
                }
                if (condition instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                    condition = parenthesizedExpression.getExpression();
                    continue;
                }
                if (condition instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                    condition = prefixExpression.getOperand();
                    continue;
                }
                if (!(condition instanceof PsiPostfixExpression)) break;
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)condition;
                condition = postfixExpression.getOperand();
            }
            return false;
        }

        private boolean isInstanceofOnLibraryClass(PsiInstanceOfExpression instanceOfExpression) {
            PsiTypeElement checkType = instanceOfExpression.getCheckType();
            if (checkType == null) {
                return false;
            }
            PsiType type = checkType.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            return LibraryUtil.classIsInLibrary(aClass);
        }
    }
}

