/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.Consumer;
import com.siyeh.ig.telemetry.InspectionGadgetsTelemetry;
import org.jetbrains.annotations.NotNull;

public class InspectionGadgetsPlugin
implements ApplicationComponent {
    public static boolean getUpToDateTelemetryEnabled(final @NotNull Consumer<Boolean> consumer, @NotNull Disposable disposable) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/InspectionGadgetsPlugin", "getUpToDateTelemetryEnabled"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/InspectionGadgetsPlugin", "getUpToDateTelemetryEnabled"));
        }
        RegistryValue registryValue = Registry.get((String)"inspectionGadgets.telemetry.enabled");
        registryValue.addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(RegistryValue value) {
                consumer.consume((Object)value.asBoolean());
            }
        }, disposable);
        return registryValue.asBoolean();
    }

    public static InspectionGadgetsPlugin getInstance() {
        return (InspectionGadgetsPlugin)ApplicationManager.getApplication().getComponent(InspectionGadgetsPlugin.class);
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("InspectionGadgets" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/InspectionGadgetsPlugin", "getComponentName"));
        }
        return "InspectionGadgets";
    }

    @NotNull
    public InspectionGadgetsTelemetry getTelemetry() {
        InspectionGadgetsTelemetry inspectionGadgetsTelemetry = InspectionGadgetsTelemetry.getInstance();
        if (inspectionGadgetsTelemetry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/InspectionGadgetsPlugin", "getTelemetry"));
        }
        return inspectionGadgetsTelemetry;
    }

    public void initComponent() {
        boolean telemetryEnabled = InspectionGadgetsPlugin.getUpToDateTelemetryEnabled(new Consumer<Boolean>(){

            public void consume(Boolean value) {
                boolean enabled = value;
                InspectionGadgetsTelemetry.setEnabled(enabled);
            }
        }, (Disposable)ApplicationManager.getApplication());
        InspectionGadgetsTelemetry.setEnabled(telemetryEnabled);
    }

    public boolean isTelemetryEnabled() {
        return InspectionGadgetsTelemetry.isEnabled();
    }
}

