/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlRefCountHolder;
import org.jetbrains.annotations.NotNull;

public class XmlDuplicatedIdInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/XmlDuplicatedIdInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                if (value.getTextRange().isEmpty()) {
                    return;
                }
                PsiFile file = value.getContainingFile();
                if (!(file instanceof XmlFile)) {
                    return;
                }
                PsiFile baseFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file);
                if (baseFile != file && !(baseFile instanceof XmlFile)) {
                    return;
                }
                XmlRefCountHolder refHolder = XmlRefCountHolder.getRefCountHolder((XmlElement)value);
                if (refHolder == null) {
                    return;
                }
                PsiElement parent = value.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    return;
                }
                XmlTag tag = (XmlTag)parent.getParent();
                if (tag == null) {
                    return;
                }
                XmlDuplicatedIdInspection.this.checkValue(value, (XmlFile)file, refHolder, tag, holder);
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlDuplicatedIdInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    protected void checkValue(XmlAttributeValue value, XmlFile file, XmlRefCountHolder refHolder, XmlTag tag, ProblemsHolder holder) {
        if (refHolder.isValidatable(tag.getParent()) && refHolder.isDuplicateIdAttributeValue(value)) {
            holder.registerProblem((PsiElement)value, XmlErrorMessages.message("duplicate.id.reference", new Object[0]), ProblemHighlightType.GENERIC_ERROR, ElementManipulators.getValueTextRange((PsiElement)value), new LocalQuickFix[0]);
        }
    }
}

