/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.reference.SoftReference;
import com.intellij.xml.util.IncludedXmlAttribute;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.IncludedXmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncludedXmlElement<T extends XmlElement>
extends LightElement
implements XmlElement {
    private final PsiAnchor myOriginal;
    private SoftReference<T> myRef;
    private final PsiElement myParent;

    public IncludedXmlElement(@NotNull T original, @Nullable PsiElement parent) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/IncludedXmlElement", "<init>"));
        }
        super(original.getManager(), original.getLanguage());
        T realOriginal = original instanceof IncludedXmlElement ? ((IncludedXmlElement)((Object)original)).getOriginal() : original;
        this.myOriginal = PsiAnchor.create(realOriginal);
        this.myRef = new SoftReference(realOriginal);
        this.myParent = parent;
    }

    @Override
    public boolean isValid() {
        XmlElement t = (XmlElement)this.myRef.get();
        if (t != null) {
            return t.isValid();
        }
        return this.myOriginal.retrieve() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IncludedXmlElement element = (IncludedXmlElement)((Object)o);
        if (!this.myParent.equals(element.myParent)) {
            return false;
        }
        return this.myOriginal.equals(element.myOriginal);
    }

    public int hashCode() {
        int result = this.myOriginal.hashCode();
        result = 31 * result + this.myParent.hashCode();
        return result;
    }

    public T getOriginal() {
        XmlElement element = (XmlElement)this.myRef.get();
        if (element != null) {
            return (T)element;
        }
        element = (XmlElement)this.myOriginal.retrieve();
        if (element == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        this.myRef = new SoftReference((Object)element);
        return (T)element;
    }

    @NotNull
    public T getNavigationElement() {
        T t = this.getOriginal();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/IncludedXmlElement", "getNavigationElement"));
        }
        return t;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myParent.getContainingFile();
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean processElements(final PsiElementProcessor processor, PsiElement place) {
        final IncludedXmlElement self = this;
        return this.getOriginal().processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/IncludedXmlElement$1", "execute"));
                }
                if (element instanceof XmlTag) {
                    XmlTag theirParent = ((XmlTag)element).getParentTag();
                    XmlTag parent = IncludedXmlElement.this.getOriginal().equals(theirParent) ? (XmlTag)self : theirParent;
                    return processor.execute((PsiElement)new IncludedXmlTag((XmlTag)element, (PsiElement)parent));
                }
                if (element instanceof XmlAttribute) {
                    XmlTag theirParent = ((XmlAttribute)element).getParent();
                    XmlTag parent = IncludedXmlElement.this.getOriginal().equals(theirParent) ? (XmlTag)self : theirParent;
                    return processor.execute((PsiElement)new IncludedXmlAttribute((XmlAttribute)element, parent));
                }
                if (element instanceof XmlText) {
                    XmlTag theirParent = ((XmlText)element).getParentTag();
                    XmlTag parent = IncludedXmlElement.this.getOriginal().equals(theirParent) ? (XmlTag)self : theirParent;
                    return processor.execute((PsiElement)new IncludedXmlText((XmlText)element, parent));
                }
                return processor.execute(element);
            }
        }, place);
    }
}

