/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dtd;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.xml.XmlContentParticle;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlElementsGroupImpl
implements XmlElementsGroup {
    private final XmlContentParticle myParticle;
    private final XmlElementsGroup myParent;
    private final NotNullLazyValue<List<XmlElementsGroup>> mySubGroups;

    public XmlElementsGroupImpl(@NotNull XmlContentParticle particle, XmlElementsGroup parent) {
        if (particle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/impl/dtd/XmlElementsGroupImpl", "<init>"));
        }
        this.mySubGroups = new NotNullLazyValue<List<XmlElementsGroup>>(){

            @NotNull
            protected List<XmlElementsGroup> compute() {
                List list = ContainerUtil.map((Object[])XmlElementsGroupImpl.this.myParticle.getSubParticles(), (Function)new Function<XmlContentParticle, XmlElementsGroup>(){

                    public XmlElementsGroup fun(XmlContentParticle xmlContentParticle) {
                        return new XmlElementsGroupImpl(xmlContentParticle, XmlElementsGroupImpl.this);
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/dtd/XmlElementsGroupImpl$1", "compute"));
                }
                return list;
            }
        };
        this.myParticle = particle;
        this.myParent = parent;
    }

    public int getMinOccurs() {
        switch (this.myParticle.getQuantifier()) {
            case ONE_OR_MORE: 
            case REQUIRED: {
                return 1;
            }
            case ZERO_OR_MORE: 
            case OPTIONAL: {
                return 0;
            }
        }
        throw new AssertionError(this.myParticle.getQuantifier());
    }

    public int getMaxOccurs() {
        switch (this.myParticle.getQuantifier()) {
            case ONE_OR_MORE: 
            case ZERO_OR_MORE: {
                return Integer.MAX_VALUE;
            }
            case REQUIRED: 
            case OPTIONAL: {
                return 1;
            }
        }
        throw new AssertionError(this.myParticle.getQuantifier());
    }

    public XmlElementsGroup.Type getGroupType() {
        switch (this.myParticle.getType()) {
            case SEQUENCE: {
                return XmlElementsGroup.Type.SEQUENCE;
            }
            case CHOICE: {
                return XmlElementsGroup.Type.CHOICE;
            }
            case ELEMENT: {
                return XmlElementsGroup.Type.LEAF;
            }
        }
        throw new AssertionError(this.myParticle.getType());
    }

    public XmlElementsGroup getParentGroup() {
        return this.myParent;
    }

    public List<XmlElementsGroup> getSubGroups() {
        return (List)this.mySubGroups.getValue();
    }

    public XmlElementDescriptor getLeafDescriptor() {
        return this.myParticle.getElementDescriptor();
    }
}

