/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WatchMessageNode
extends MessageTreeNode
implements WatchNode {
    private final String myExpression;

    private WatchMessageNode(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String expression, Icon icon) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode", "<init>"));
        }
        super(tree, parent, true);
        this.myExpression = expression;
        this.setIcon(icon);
    }

    @Override
    @NotNull
    public String getExpression() {
        String string = this.myExpression;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode", "getExpression"));
        }
        return string;
    }

    public static WatchMessageNode createMessageNode(XDebuggerTree tree, XDebuggerTreeNode parent, String expression) {
        WatchMessageNode node = new WatchMessageNode(tree, parent, expression, AllIcons.Debugger.Watch);
        node.myText.append(expression, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return node;
    }

    public static WatchMessageNode createEvaluatingNode(XDebuggerTree tree, XDebuggerTreeNode parent, String expression) {
        WatchMessageNode node = new WatchMessageNode(tree, parent, expression, AllIcons.Debugger.Watch);
        node.myText.append(expression + " = ...", XDebuggerUIConstants.EVALUATING_EXPRESSION_HIGHLIGHT_ATTRIBUTES);
        return node;
    }

    public static WatchMessageNode createErrorNode(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String expression, @NotNull String errorMessage) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode", "createErrorNode"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchMessageNode", "createErrorNode"));
        }
        WatchMessageNode node = new WatchMessageNode(tree, parent, expression, XDebuggerUIConstants.ERROR_MESSAGE_ICON);
        node.myText.append(expression + " = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        node.myText.append(errorMessage, SimpleTextAttributes.ERROR_ATTRIBUTES);
        return node;
    }

    public String toString() {
        return this.myExpression;
    }
}

