/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import java.awt.Dimension;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerExpressionComboBox
extends XDebuggerEditorBase {
    private final ComboBox myComboBox;
    private EditorComboBoxEditor myEditor;
    private final XDebuggerEditorsProvider myDebuggerEditorsProvider;
    private String myExpression;

    public XDebuggerExpressionComboBox(@NotNull Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/XDebuggerExpressionComboBox", "<init>"));
        }
        if (debuggerEditorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/XDebuggerExpressionComboBox", "<init>"));
        }
        super(project, debuggerEditorsProvider, EvaluationMode.EXPRESSION, historyId, sourcePosition);
        this.myDebuggerEditorsProvider = debuggerEditorsProvider;
        this.myComboBox = new ComboBox();
        this.myComboBox.setEditable(true);
        this.myExpression = "";
        Dimension minimumSize = new Dimension(this.myComboBox.getMinimumSize());
        minimumSize.width = 100;
        this.myComboBox.setMinimumSize(minimumSize);
        this.initEditor();
        this.fillComboBox();
    }

    public ComboBox getComboBox() {
        return this.myComboBox;
    }

    @Override
    public JComponent getComponent() {
        return this.myComboBox;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor.getEditor();
    }

    public JComponent getEditorComponent() {
        return this.myEditor.getEditorComponent();
    }

    public void setEnabled(boolean enable) {
        if (enable == this.myComboBox.isEnabled()) {
            return;
        }
        this.myComboBox.setEnabled(enable);
        this.myComboBox.setEditable(enable);
        if (enable) {
            this.initEditor();
        } else {
            this.myExpression = this.getText();
        }
    }

    private void initEditor() {
        this.myEditor = new EditorComboBoxEditor(this.getProject(), this.myDebuggerEditorsProvider.getFileType()){

            @Override
            public void setItem(Object anObject) {
                super.setItem(XDebuggerExpressionComboBox.this.createDocument(StringUtil.notNullize((String)((String)anObject))));
            }

            @Override
            public Object getItem() {
                return ((Document)super.getItem()).getText();
            }
        };
        this.myComboBox.setEditor((ComboBoxEditor)this.myEditor);
        this.myEditor.setItem(this.myExpression);
        this.myComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)this.myEditor));
        this.myComboBox.setMaximumRowCount(10);
    }

    @Override
    protected void onHistoryChanged() {
        this.fillComboBox();
    }

    private void fillComboBox() {
        this.myComboBox.removeAllItems();
        for (String expression : this.getRecentExpressions()) {
            this.myComboBox.addItem((Object)expression);
        }
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
    }

    @Override
    protected void doSetText(String text) {
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
        if (this.myComboBox.isEditable()) {
            this.myEditor.setItem(text);
        } else {
            this.myExpression = text;
        }
    }

    @Override
    public String getText() {
        Object value = this.myComboBox.isPopupVisible() ? this.myComboBox.getPopup().getList().getSelectedValue() : this.myEditor.getItem();
        return StringUtil.notNullize((String)((String)value));
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myComboBox.getEditor().getEditorComponent();
    }

    @Override
    public void selectAll() {
        this.myComboBox.getEditor().selectAll();
    }
}

