/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorBase {
    private final Project myProject;
    private final XDebuggerEditorsProvider myDebuggerEditorsProvider;
    @NotNull
    private final EvaluationMode myMode;
    @Nullable
    private final String myHistoryId;
    private final XSourcePosition mySourcePosition;
    private int myHistoryIndex;

    protected XDebuggerEditorBase(Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @NotNull EvaluationMode mode, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        if (debuggerEditorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "<init>"));
        }
        this.myProject = project;
        this.myDebuggerEditorsProvider = debuggerEditorsProvider;
        this.myMode = mode;
        this.myHistoryId = historyId;
        this.mySourcePosition = sourcePosition;
    }

    @NotNull
    public EvaluationMode getMode() {
        EvaluationMode evaluationMode = this.myMode;
        if (evaluationMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getMode"));
        }
        return evaluationMode;
    }

    public abstract JComponent getComponent();

    protected abstract void doSetText(String var1);

    public void setText(String text) {
        this.saveTextInHistory(text);
        this.doSetText(text);
    }

    public abstract String getText();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public abstract void selectAll();

    protected void onHistoryChanged() {
    }

    protected List<String> getRecentExpressions() {
        if (this.myHistoryId != null) {
            return XDebuggerHistoryManager.getInstance(this.myProject).getRecentExpressions(this.myHistoryId);
        }
        return Collections.emptyList();
    }

    public void saveTextInHistory() {
        this.saveTextInHistory(this.getText());
    }

    private void saveTextInHistory(String text) {
        if (this.myHistoryId != null) {
            XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression(this.myHistoryId, text);
            this.myHistoryIndex = 0;
            this.onHistoryChanged();
        }
    }

    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myDebuggerEditorsProvider;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Document createDocument(String text) {
        return this.getEditorsProvider().createDocument(this.getProject(), text, this.mySourcePosition, this.myMode);
    }

    public boolean canGoBackward() {
        return this.myHistoryIndex < this.getRecentExpressions().size() - 1;
    }

    public boolean canGoForward() {
        return this.myHistoryIndex > 0;
    }

    public void goBackward() {
        List<String> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex < expressions.size() - 1) {
            ++this.myHistoryIndex;
            this.doSetText(expressions.get(this.myHistoryIndex));
        }
    }

    public void goForward() {
        List<String> expressions = this.getRecentExpressions();
        if (this.myHistoryIndex > 0) {
            --this.myHistoryIndex;
            this.doSetText(expressions.get(this.myHistoryIndex));
        }
    }
}

