/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RestartAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebugViewSessionListener;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.tree.actions.SortValuesToggleAction;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionTab
extends DebuggerSessionTabBase {
    private XWatchesViewImpl myWatchesView;
    private final List<XDebugView> myViews;

    public XDebugSessionTab(@NotNull Project project, @NotNull XDebugSessionImpl session, @Nullable Icon icon, ExecutionEnvironment environment, ProgramRunner runner) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/XDebugSessionTab", "<init>"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/ui/XDebugSessionTab", "<init>"));
        }
        super(project, "Debug", session.getSessionName(), GlobalSearchScope.allScope((Project)project));
        this.myViews = new ArrayList<XDebugView>();
        if (environment != null) {
            this.setEnvironment(environment);
        }
        this.myConsole = session.getConsoleView();
        XDebugProcess debugProcess = session.getDebugProcess();
        this.myRunContentDescriptor = new RunContentDescriptor(this.myConsole, debugProcess.getProcessHandler(), this.myUi.getComponent(), this.mySessionName, icon);
        this.attachToSession(session, runner, environment, session.getSessionData(), debugProcess);
    }

    private Content createVariablesContent(XDebugSession session) {
        XVariablesView variablesView = new XVariablesView(session);
        this.myViews.add(variablesView);
        Content result = this.myUi.createContent("VariablesContent", variablesView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]), AllIcons.Debugger.Value, null);
        result.setCloseable(false);
        ActionGroup group = XDebugSessionTab.getCustomizedActionGroup("XDebugger.Variables.Tree.Toolbar");
        result.setActions(group, "DebuggerToolbar", (JComponent)((Object)variablesView.getTree()));
        return result;
    }

    private Content createWatchesContent(XDebugSession session, XDebugSessionData sessionData) {
        this.myWatchesView = new XWatchesViewImpl(session, sessionData);
        this.myViews.add(this.myWatchesView);
        Content watchesContent = this.myUi.createContent("WatchesContent", (JComponent)this.myWatchesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.watches.title", (Object[])new Object[0]), AllIcons.Debugger.Watches, null);
        watchesContent.setCloseable(false);
        return watchesContent;
    }

    private Content createFramesContent(XDebugSession session) {
        XFramesView framesView = new XFramesView(session);
        this.myViews.add(framesView);
        Content framesContent = this.myUi.createContent("FrameContent", (JComponent)framesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.frames.title", (Object[])new Object[0]), AllIcons.Debugger.Frame, null);
        framesContent.setCloseable(false);
        return framesContent;
    }

    public ExecutionConsole getConsole() {
        return this.myConsole;
    }

    public void rebuildViews() {
        AppUIUtil.invokeLaterIfProjectAlive(this.getProject(), new Runnable(){

            @Override
            public void run() {
                for (XDebugView view : XDebugSessionTab.this.myViews) {
                    view.processSessionEvent(XDebugView.SessionEvent.SETTINGS_CHANGED);
                }
            }
        });
    }

    public XWatchesView getWatchesView() {
        return this.myWatchesView;
    }

    private void attachToSession(final @NotNull XDebugSessionImpl session, @Nullable ProgramRunner runner, @Nullable ExecutionEnvironment env, @NotNull XDebugSessionData sessionData, @NotNull XDebugProcess debugProcess) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/XDebugSessionTab", "attachToSession"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/xdebugger/impl/ui/XDebugSessionTab", "attachToSession"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/xdebugger/impl/ui/XDebugSessionTab", "attachToSession"));
        }
        this.myUi.addContent(this.createFramesContent(session), 0, PlaceInGrid.left, false);
        this.myUi.addContent(this.createVariablesContent(session), 0, PlaceInGrid.center, false);
        this.myUi.addContent(this.createWatchesContent(session, sessionData), 0, PlaceInGrid.right, false);
        for (XDebugView view : this.myViews) {
            Disposer.register((Disposable)this, (Disposable)view);
            session.addSessionListener((XDebugSessionListener)new XDebugViewSessionListener(view, this.getProject()), this);
        }
        this.myUi.getContentManager().addDataProvider(new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (XWatchesView.DATA_KEY.is(dataId)) {
                    return XDebugSessionTab.this.myWatchesView;
                }
                if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
                    return session.getConsoleView();
                }
                return null;
            }
        });
        XDebugTabLayouter layouter = debugProcess.createTabLayouter();
        Content consoleContent = layouter.registerConsoleContent(this.myUi, this.myConsole);
        this.attachNotificationTo(consoleContent);
        layouter.registerAdditionalContent(this.myUi);
        RunContentBuilder.addAdditionalConsoleEditorActions(this.myConsole, consoleContent);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        DefaultActionGroup leftToolbar = new DefaultActionGroup();
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        if (runner != null && env != null) {
            RestartAction restartAction = new RestartAction(executor, runner, this.myRunContentDescriptor, env);
            leftToolbar.add((AnAction)restartAction);
            restartAction.registerShortcut(this.myUi.getComponent());
            List<AnAction> additionalRestartActions = session.getRestartActions();
            leftToolbar.addAll(additionalRestartActions);
            if (!additionalRestartActions.isEmpty()) {
                leftToolbar.addSeparator();
            }
        }
        leftToolbar.addAll(XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.LeftToolbar"));
        leftToolbar.addSeparator();
        leftToolbar.add(this.myUi.getOptions().getLayoutActions());
        AnAction[] commonSettings = this.myUi.getOptions().getSettingsActionsList();
        final AnAction commonSettingsList = this.myUi.getOptions().getSettingsActions();
        DefaultActionGroup settings = new DefaultActionGroup("DebuggerSettings", commonSettings.length > 0){

            public void update(AnActionEvent e) {
                e.getPresentation().setText(ActionsBundle.message((String)"group.XDebugger.settings.text", (Object[])new Object[0]));
                e.getPresentation().setIcon(commonSettingsList.getTemplatePresentation().getIcon());
            }

            public boolean isDumbAware() {
                return true;
            }
        };
        for (AnAction each : commonSettings) {
            settings.add(each);
        }
        if (commonSettings.length > 0) {
            settings.addSeparator();
        }
        if (!debugProcess.isValuesCustomSorted()) {
            settings.add((AnAction)new ToggleSortValuesAction(commonSettings.length == 0));
        }
        leftToolbar.add((AnAction)settings);
        leftToolbar.addSeparator();
        leftToolbar.add(PinToolwindowTabAction.getPinAction());
        leftToolbar.add((AnAction)new CloseAction(executor, this.myRunContentDescriptor, this.getProject()));
        leftToolbar.add((AnAction)new ContextHelpAction(executor.getHelpId()));
        DefaultActionGroup topToolbar = new DefaultActionGroup();
        topToolbar.addAll(XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar"));
        debugProcess.registerAdditionalActions(leftToolbar, topToolbar);
        this.myUi.getOptions().setLeftToolbar((ActionGroup)leftToolbar, "DebuggerToolbar");
        this.myUi.getOptions().setTopToolbar((ActionGroup)topToolbar, "DebuggerToolbar");
        if (env != null) {
            RunProfile runConfiguration = env.getRunProfile();
            this.registerFileMatcher(runConfiguration);
            this.initLogConsoles(runConfiguration, this.myRunContentDescriptor.getProcessHandler(), this.myConsole);
        }
        this.rebuildViews();
    }

    @Override
    @Nullable
    public RunContentDescriptor getRunContentDescriptor() {
        return this.myRunContentDescriptor;
    }

    private static class ToggleSortValuesAction
    extends SortValuesToggleAction {
        private final boolean myShowIcon;

        private ToggleSortValuesAction(boolean showIcon) {
            this.copyFrom(ActionManager.getInstance().getAction("XDebugger.ToggleSortValues"));
            this.myShowIcon = showIcon;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (!this.myShowIcon) {
                e.getPresentation().setIcon(null);
            }
        }
    }
}

