/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPointHighlighter {
    private final Project myProject;
    private RangeHighlighter myRangeHighlighter;
    private Editor myEditor;
    private XSourcePosition mySourcePosition;
    private OpenFileDescriptor myOpenFileDescriptor;
    private boolean myUseSelection;
    private GutterIconRenderer myGutterIconRenderer;
    private static final Key<Boolean> EXECUTION_POINT_HIGHLIGHTER_KEY = Key.create((String)"EXECUTION_POINT_HIGHLIGHTER_KEY");
    private final AtomicBoolean updateRequested = new AtomicBoolean();

    public ExecutionPointHighlighter(Project project) {
        this.myProject = project;
    }

    public void show(final @NotNull XSourcePosition position, final boolean useSelection, final @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "show"));
        }
        this.updateRequested.set(false);
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, new Runnable(){

            @Override
            public void run() {
                ExecutionPointHighlighter.this.updateRequested.set(false);
                ExecutionPointHighlighter.this.mySourcePosition = position;
                ExecutionPointHighlighter.this.myOpenFileDescriptor = XSourcePositionImpl.createOpenFileDescriptor(ExecutionPointHighlighter.this.myProject, position);
                ExecutionPointHighlighter.this.myOpenFileDescriptor.setUseCurrentWindow(true);
                ExecutionPointHighlighter.this.myGutterIconRenderer = gutterIconRenderer;
                ExecutionPointHighlighter.this.myUseSelection = useSelection;
                ExecutionPointHighlighter.this.doShow();
            }
        });
    }

    public void hide() {
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                ExecutionPointHighlighter.this.updateRequested.set(false);
                ExecutionPointHighlighter.this.removeHighlighter();
                ExecutionPointHighlighter.this.myOpenFileDescriptor = null;
                ExecutionPointHighlighter.this.myEditor = null;
                ExecutionPointHighlighter.this.myGutterIconRenderer = null;
            }
        });
    }

    public void navigateTo() {
        if (this.myOpenFileDescriptor != null) {
            this.myOpenFileDescriptor.navigateInEditor(this.myProject, true);
        }
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        return this.myOpenFileDescriptor != null ? this.myOpenFileDescriptor.getFile() : null;
    }

    public void update() {
        if (this.updateRequested.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ExecutionPointHighlighter.this.updateRequested.compareAndSet(true, false)) {
                        ExecutionPointHighlighter.this.doShow();
                    }
                }
            }, this.myProject.getDisposed());
        }
    }

    public void updateGutterIcon(final @NotNull GutterIconRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "updateGutterIcon"));
        }
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                if (ExecutionPointHighlighter.this.myRangeHighlighter != null && ExecutionPointHighlighter.this.myGutterIconRenderer != null) {
                    ExecutionPointHighlighter.this.myRangeHighlighter.setGutterIconRenderer(renderer);
                }
            }
        });
    }

    private void doShow() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.removeHighlighter();
        Editor editor = this.myEditor = this.myOpenFileDescriptor == null ? null : XDebuggerUtilImpl.createEditor(this.myOpenFileDescriptor);
        if (this.myEditor != null) {
            this.addHighlighter();
        }
    }

    private void removeHighlighter() {
        if (this.myRangeHighlighter == null || this.myEditor == null) {
            return;
        }
        if (this.myUseSelection) {
            this.myEditor.getSelectionModel().removeSelection();
        }
        this.myRangeHighlighter.dispose();
        this.myRangeHighlighter = null;
    }

    private void addHighlighter() {
        Document document;
        int line = this.mySourcePosition.getLine();
        if (line >= (document = this.myEditor.getDocument()).getLineCount()) {
            return;
        }
        if (this.myUseSelection) {
            this.myEditor.getSelectionModel().setSelection(document.getLineStartOffset(line), document.getLineEndOffset(line) + document.getLineSeparatorLength(line));
            return;
        }
        if (this.myRangeHighlighter != null) {
            return;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myRangeHighlighter = this.myEditor.getMarkupModel().addLineHighlighter(line, 5999, scheme.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES));
        this.myRangeHighlighter.putUserData(EXECUTION_POINT_HIGHLIGHTER_KEY, (Object)true);
        this.myRangeHighlighter.setGutterIconRenderer(this.myGutterIconRenderer);
    }
}

