/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="XDebuggerSettings", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class XDebuggerSettingsManager
implements PersistentStateComponent<SettingsState> {
    @NonNls
    public static final String COMPONENT_NAME = "XDebuggerSettings";
    private Map<String, XDebuggerSettings<?>> mySettingsById;
    private Map<Class<? extends XDebuggerSettings>, XDebuggerSettings<?>> mySettingsByClass;
    private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();

    public static XDebuggerSettingsManager getInstance() {
        return (XDebuggerSettingsManager)ServiceManager.getService(XDebuggerSettingsManager.class);
    }

    public SettingsState getState() {
        SettingsState settingsState = new SettingsState();
        settingsState.setDataViewSettings(this.myDataViewSettings);
        for (XDebuggerSettings<?> settings : this.getSettingsList()) {
            SpecificSettingsState state = new SpecificSettingsState();
            state.setId(settings.getId());
            state.setSettingsElement(XmlSerializer.serialize((Object)settings.getState(), (SerializationFilter)new SkipDefaultValuesSerializationFilters()));
            settingsState.getSpecificStates().add(state);
        }
        return settingsState;
    }

    public Collection<XDebuggerSettings<?>> getSettingsList() {
        this.initSettings();
        return Collections.unmodifiableCollection(this.mySettingsById.values());
    }

    public XDebuggerDataViewSettings getDataViewSettings() {
        return this.myDataViewSettings;
    }

    public void loadState(SettingsState state) {
        this.myDataViewSettings = state.getDataViewSettings();
        for (SpecificSettingsState settingsState : state.getSpecificStates()) {
            XDebuggerSettings settings = this.findSettings(settingsState.getId());
            if (settings == null) continue;
            ComponentSerializationUtil.loadComponentState(settings, settingsState.getSettingsElement());
        }
    }

    private XDebuggerSettings findSettings(String id) {
        this.initSettings();
        return this.mySettingsById.get(id);
    }

    private void initSettings() {
        if (this.mySettingsById == null) {
            this.mySettingsById = new HashMap();
            this.mySettingsByClass = new HashMap();
            for (XDebuggerSettings settings : (XDebuggerSettings[])Extensions.getExtensions((ExtensionPointName)XDebuggerSettings.EXTENSION_POINT)) {
                this.mySettingsById.put(settings.getId(), settings);
                this.mySettingsByClass.put(settings.getClass(), settings);
            }
        }
    }

    public <T extends XDebuggerSettings<?>> T getSettings(Class<T> aClass) {
        this.initSettings();
        return (T)this.mySettingsByClass.get(aClass);
    }

    @Tag(value="debugger")
    public static class SpecificSettingsState {
        private String myId;
        private Element mySettingsElement;

        @Attribute(value="id")
        public String getId() {
            return this.myId;
        }

        @Tag(value="configuration")
        public Element getSettingsElement() {
            return this.mySettingsElement;
        }

        public void setSettingsElement(Element settingsElement) {
            this.mySettingsElement = settingsElement;
        }

        public void setId(String id) {
            this.myId = id;
        }
    }

    public static class SettingsState {
        private List<SpecificSettingsState> mySpecificStates = new ArrayList<SpecificSettingsState>();
        private XDebuggerDataViewSettings myDataViewSettings = new XDebuggerDataViewSettings();

        @Tag(value="debuggers")
        @AbstractCollection(surroundWithTag=false)
        public List<SpecificSettingsState> getSpecificStates() {
            return this.mySpecificStates;
        }

        public void setSpecificStates(List<SpecificSettingsState> specificStates) {
            this.mySpecificStates = specificStates;
        }

        @Property(surroundWithTag=false)
        public XDebuggerDataViewSettings getDataViewSettings() {
            return this.myDataViewSettings;
        }

        public void setDataViewSettings(XDebuggerDataViewSettings dataViewSettings) {
            this.myDataViewSettings = dataViewSettings;
        }
    }
}

