/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.util.PlatformUtils;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.settings.DebuggerConfigurable;
import com.intellij.xdebugger.impl.settings.DebuggerSettingsPanelProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DebuggerConfigurableProvider
extends ConfigurableProvider {
    public Configurable createConfigurable() {
        DebuggerSupport[] supports;
        ArrayList<DebuggerSettingsPanelProvider> providers = new ArrayList<DebuggerSettingsPanelProvider>();
        for (DebuggerSupport support : supports = DebuggerSupport.getDebuggerSupports()) {
            providers.add(support.getSettingsPanelProvider());
        }
        List<Object> configurables = new ArrayList<Configurable>();
        Collections.sort(providers, new Comparator<DebuggerSettingsPanelProvider>(){

            @Override
            public int compare(DebuggerSettingsPanelProvider o1, DebuggerSettingsPanelProvider o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        Configurable rootConfigurable = null;
        for (DebuggerSettingsPanelProvider provider : providers) {
            configurables.addAll(provider.getConfigurables());
            Configurable aRootConfigurable = provider.getRootConfigurable();
            if (aRootConfigurable == null) continue;
            if (rootConfigurable != null) {
                configurables.add(aRootConfigurable);
                continue;
            }
            rootConfigurable = aRootConfigurable;
        }
        if (configurables.isEmpty() && rootConfigurable == null) {
            return null;
        }
        if (PlatformUtils.isCidr() && rootConfigurable == null && configurables.size() == 1) {
            rootConfigurable = (Configurable)configurables.get(0);
            configurables = Collections.emptyList();
        }
        return new DebuggerConfigurable(rootConfigurable, configurables);
    }
}

