/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.DebuggerSupport;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DebuggerConfigurable
implements SearchableConfigurable.Parent {
    public static final String DISPLAY_NAME = XDebuggerBundle.message((String)"debugger.configurable.display.name", (Object[])new Object[0]);
    private Configurable myRootConfigurable;
    private Configurable[] myChildren;

    public DebuggerConfigurable(Configurable rootConfigurable, List<Configurable> children) {
        this.myRootConfigurable = rootConfigurable;
        this.myChildren = children.toArray(new Configurable[children.size()]);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return this.myRootConfigurable != null ? this.myRootConfigurable.getHelpTopic() : null;
    }

    public Configurable[] getConfigurables() {
        return this.myChildren;
    }

    public void apply() throws ConfigurationException {
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            support.getSettingsPanelProvider().apply();
        }
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.apply();
        }
    }

    public boolean hasOwnContent() {
        return this.myRootConfigurable != null;
    }

    public boolean isVisible() {
        return true;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myRootConfigurable != null ? this.myRootConfigurable.createComponent() : null;
    }

    public boolean isModified() {
        return this.myRootConfigurable != null && this.myRootConfigurable.isModified();
    }

    public void reset() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.disposeUIResources();
        }
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("project.propDebugger" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "getId"));
        }
        return "project.propDebugger";
    }
}

