/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class XWatchesViewImpl
implements DnDNativeTarget,
XWatchesView,
XDebugView {
    private final XDebuggerTreePanel myTreePanel;
    private XDebuggerTreeState myTreeState;
    private XDebuggerTreeRestorer myTreeRestorer;
    private final WatchesRootNode myRootNode;
    @NotNull
    private final XDebugSession mySession;
    private final XDebugSessionData mySessionData;
    private final JPanel myDecoratedPanel;

    public XWatchesViewImpl(@NotNull XDebugSession session, @NotNull XDebugSessionData sessionData) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "<init>"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "<init>"));
        }
        this.mySession = session;
        this.mySessionData = sessionData;
        this.myTreePanel = new XDebuggerTreePanel(session.getProject(), session.getDebugProcess().getEditorsProvider(), this, null, "XDebugger.Watches.Tree.Popup", ((XDebugSessionImpl)session).getValueMarkers());
        ActionManager actionManager = ActionManager.getInstance();
        XDebuggerTree tree = this.myTreePanel.getTree();
        actionManager.getAction("XDebugger.NewWatch").registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)tree));
        actionManager.getAction("XDebugger.RemoveWatch").registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)((Object)tree));
        CustomShortcutSet f2Shortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0));
        actionManager.getAction("XDebugger.EditWatch").registerCustomShortcutSet((ShortcutSet)f2Shortcut, (JComponent)((Object)tree));
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)tree));
        this.myRootNode = new WatchesRootNode(tree, session, this, sessionData.getWatchExpressions());
        tree.setRoot(this.myRootNode, false);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTreePanel.getTree())).disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                XWatchesViewImpl.this.executeAction("XDebugger.NewWatch");
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                XWatchesViewImpl.this.executeAction("XDebugger.RemoveWatch");
            }
        });
        CustomLineBorder border = new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, SystemInfo.isMac ? 1 : 0, 0, SystemInfo.isMac ? 0 : 1, 0);
        decorator.setToolbarBorder((Border)border);
        this.myDecoratedPanel = decorator.createPanel();
        this.myDecoratedPanel.setBorder(null);
        this.myTreePanel.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.watches", (Object[])new Object[0]));
    }

    public void dispose() {
        DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.myTreePanel.getTree()));
    }

    private void executeAction(@NotNull String watch) {
        if (watch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "executeAction"));
        }
        AnAction action = ActionManager.getInstance().getAction(watch);
        Presentation presentation = action.getTemplatePresentation().clone();
        DataContext context = DataManager.getInstance().getDataContext((Component)((Object)this.myTreePanel.getTree()));
        AnActionEvent actionEvent = new AnActionEvent(null, context, "DebuggerToolbar", presentation, ActionManager.getInstance(), 0);
        action.actionPerformed(actionEvent);
    }

    @Override
    public void addWatchExpression(@NotNull String expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "addWatchExpression"));
        }
        this.myRootNode.addWatchExpression(this.mySession.getDebugProcess().getEvaluator(), expression, index, navigateToWatchNode);
        this.updateSessionData();
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "processSessionEvent"));
        }
        XStackFrame stackFrame = this.mySession.getCurrentStackFrame();
        XDebuggerTree tree = this.myTreePanel.getTree();
        if (event == XDebugView.SessionEvent.BEFORE_RESUME || event == XDebugView.SessionEvent.SETTINGS_CHANGED) {
            if (this.myTreeRestorer != null) {
                this.myTreeRestorer.dispose();
            }
            this.myTreeState = XDebuggerTreeState.saveState(tree);
            if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
                return;
            }
        }
        if (stackFrame != null) {
            tree.setSourcePosition(stackFrame.getSourcePosition());
            this.myRootNode.updateWatches(stackFrame.getEvaluator());
            if (this.myTreeState != null) {
                this.myTreeRestorer = this.myTreeState.restoreState(tree);
            }
        } else {
            tree.setSourcePosition(null);
            this.myRootNode.updateWatches(null);
        }
    }

    public XDebuggerTree getTree() {
        return this.myTreePanel.getTree();
    }

    public JPanel getMainPanel() {
        return this.myDecoratedPanel;
    }

    @Override
    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        List<? extends WatchNode> children = this.myRootNode.getAllChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove = new ArrayList<XDebuggerTreeNode>();
        if (children != null) {
            for (XDebuggerTreeNode xDebuggerTreeNode : nodes) {
                int index = children.indexOf(xDebuggerTreeNode);
                if (index == -1) continue;
                toRemove.add(xDebuggerTreeNode);
                minIndex = Math.min(minIndex, index);
            }
        }
        this.myRootNode.removeChildren(toRemove);
        List<? extends WatchNode> newChildren = this.myRootNode.getAllChildren();
        if (newChildren != null && !newChildren.isEmpty()) {
            WatchNode watchNode = minIndex < newChildren.size() ? newChildren.get(minIndex) : newChildren.get(newChildren.size() - 1);
            TreeUtil.selectNode((JTree)((Object)this.myTreePanel.getTree()), (TreeNode)watchNode);
        }
        this.updateSessionData();
    }

    @Override
    public void removeAllWatches() {
        this.myRootNode.removeAllChildren();
        this.updateSessionData();
    }

    private void updateSessionData() {
        ArrayList<String> watchExpressions = new ArrayList<String>();
        List<? extends WatchNode> children = this.myRootNode.getAllChildren();
        if (children != null) {
            for (WatchNode watchNode : children) {
                watchExpressions.add(watchNode.getExpression());
            }
        }
        this.mySessionData.setWatchExpressions(ArrayUtil.toStringArray(watchExpressions));
    }

    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message((String)"xdebugger.drop.text.add.to.watches", (Object[])new Object[0]));
        return true;
    }

    public void drop(DnDEvent aEvent) {
        String text;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            XValueNodeImpl[] nodes;
            for (XValueNodeImpl node : nodes = (XValueNodeImpl[])object) {
                String expression = ((XValue)node.getValueContainer()).getEvaluationExpression();
                if (expression == null) continue;
                this.addWatchExpression(expression, -1, false);
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(text, -1, false);
        }
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }
}

